/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.AbstractDataTypeBuilderFactory;
import org.mule.runtime.api.metadata.CollectionDataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;

@NoImplement
public interface DataType
extends Serializable {
    public static final DataType TEXT_STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(String.class).mediaType(MediaType.TEXT).build());
    public static final DataType XML_STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(String.class).mediaType(MediaType.XML).build());
    public static final DataType JSON_STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_JSON).build());
    public static final DataType HTML_STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(String.class).mediaType(MediaType.HTML).build());
    public static final DataType ATOM_STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(String.class).mediaType(MediaType.ATOM).build());
    public static final DataType RSS_STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(String.class).mediaType(MediaType.RSS).build());
    public static final DataType STRING = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(String.class));
    public static final DataType NUMBER = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(Number.class));
    public static final DataType BOOLEAN = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(Boolean.class));
    public static final DataType OBJECT = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(Object.class));
    public static final DataType BYTE_ARRAY = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(byte[].class));
    public static final DataType INPUT_STREAM = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(InputStream.class));
    public static final DataType ITERATOR = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(Iterator.class));
    public static final DataType CURSOR_STREAM_PROVIDER = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(CursorStreamProvider.class));
    public static final DataType CURSOR_ITERATOR_PROVIDER = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(CursorIteratorProvider.class));
    public static final DataType TYPED_VALUE = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.fromType(TypedValue.class));
    public static final DataType MULE_MESSAGE = new DynamicDelegateDataType((Supplier<DataType> & Serializable)() -> DataType.builder().type(Message.class).mediaType(MediaType.ANY).build());
    public static final CollectionDataType MULE_MESSAGE_COLLECTION = new DynamicCollectionDelegateDataType((Supplier<DataType> & Serializable)() -> AbstractDataTypeBuilderFactory.getDefaultFactory().create().collectionType(Collection.class).itemType(Message.class).mediaType(MediaType.ANY).build());
    public static final CollectionDataType MULE_MESSAGE_LIST = new DynamicCollectionDelegateDataType((Supplier<DataType> & Serializable)() -> AbstractDataTypeBuilderFactory.getDefaultFactory().create().collectionType(List.class).itemType(Message.class).mediaType(MediaType.ANY).build());
    public static final MapDataType MULE_MESSAGE_MAP = new DynamicMapDelegateDataType((Supplier<DataType> & Serializable)() -> AbstractDataTypeBuilderFactory.getDefaultFactory().create().mapType(Map.class).keyType(String.class).valueType(Message.class).valueMediaType(MediaType.ANY).build());
    public static final MapDataType MULTI_MAP_STRING_STRING = new DynamicMapDelegateDataType((Supplier<DataType> & Serializable)() -> AbstractDataTypeBuilderFactory.getDefaultFactory().create().mapType(MultiMap.class).keyType(String.class).valueType(String.class).build());

    public static DataTypeBuilder builder() {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create();
    }

    public static DataTypeBuilder builder(DataType dataType) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create(dataType);
    }

    public static DataType fromType(Class<?> type) {
        return DataType.builder().type(type).build();
    }

    public static DataType fromObject(Object value) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create().fromObject(value).build();
    }

    public static DataType fromFunction(ExpressionFunction function) {
        return AbstractDataTypeBuilderFactory.getDefaultFactory().create().fromFunction(function).build();
    }

    public static boolean areCompatible(DataType superType, DataType subType) {
        return superType.isCompatibleWith(subType);
    }

    public Class<?> getType();

    public MediaType getMediaType();

    public boolean isCompatibleWith(DataType var1);

    public boolean isStreamType();

    public static class DynamicDelegateDataType
    implements DataType {
        private static final long serialVersionUID = -4590745924767485440L;
        private final Supplier<DataType> delegateSupplier;
        private final DataType delegate;
        private transient Map<ClassLoader, DataType> cache = new ConcurrentHashMap<ClassLoader, DataType>();

        public DynamicDelegateDataType(Supplier<DataType> delegateSupplier) {
            this.delegateSupplier = delegateSupplier;
            this.delegate = delegateSupplier.get();
        }

        public DataType getDelegate() {
            if (MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically()) {
                if (this.cache == null) {
                    this.cache = new ConcurrentHashMap<ClassLoader, DataType>();
                }
                return this.cache.computeIfAbsent(MuleImplementationLoaderUtils.getMuleImplementationsLoader(), classLoader -> this.delegateSupplier.get());
            }
            return this.delegate;
        }

        @Override
        public Class<?> getType() {
            return this.getDelegate().getType();
        }

        @Override
        public MediaType getMediaType() {
            return this.getDelegate().getMediaType();
        }

        @Override
        public boolean isCompatibleWith(DataType dataType) {
            return this.getDelegate().isCompatibleWith(dataType);
        }

        @Override
        public boolean isStreamType() {
            return this.getDelegate().isStreamType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataType)) {
                return false;
            }
            DataType that = o instanceof DynamicDelegateDataType ? ((DynamicDelegateDataType)o).getDelegate() : (DataType)o;
            return this.getDelegate().equals(that);
        }

        public int hashCode() {
            return this.getDelegate().hashCode();
        }
    }

    public static class DynamicCollectionDelegateDataType
    extends DynamicDelegateDataType
    implements CollectionDataType {
        public DynamicCollectionDelegateDataType(Supplier<DataType> delegateSupplier) {
            super(delegateSupplier);
        }

        @Override
        public DataType getItemDataType() {
            return ((CollectionDataType)this.getDelegate()).getItemDataType();
        }
    }

    public static class DynamicMapDelegateDataType
    extends DynamicDelegateDataType
    implements MapDataType {
        public DynamicMapDelegateDataType(Supplier<DataType> delegateSupplier) {
            super(delegateSupplier);
        }

        @Override
        public DataType getKeyDataType() {
            return ((MapDataType)this.getDelegate()).getKeyDataType();
        }

        @Override
        public DataType getValueDataType() {
            return ((MapDataType)this.getDelegate()).getValueDataType();
        }
    }
}

