/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.core.api.management.stats.ArtifactMeterProvider;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.metrics.api.meter.Meter;

public class DefaultFlowsSummaryStatistics
implements FlowsSummaryStatistics {
    private static final long serialVersionUID = 1L;
    public static final String FLOWS_SUMMARY_APP_STATISTICS_NAME = "flows-summary-statistic";
    public static final String FLOWS_SUMMARY_APP_STATISTICS_DESCRIPTION_TEMPLATE = "Flow summary statistics";
    public static final String DECLARED_PRIVATE_FLOWS_APP_NAME = "declared-private-flows";
    public static final String DECLARED_PRIVATE_FLOWS_APP_DESCRIPTION = "Declared Private Flows";
    public static final String ACTIVE_PRIVATE_FLOWS_APP_NAME = "active-private-flows";
    public static final String ACTIVE_PRIVATE_FLOWS_APP_DESCRIPTION = "Activate Private Flows";
    public static final String DECLARED_TRIGGER_FLOWS_APP_NAME = "declared-trigger-flows";
    public static final String DECLARED_TRIGGER_FLOWS_APP_DESCRIPTION = "Declared Trigger Flows";
    public static final String ACTIVE_TRIGGER_FLOWS_NAME = "active-trigger-flows";
    public static final String ACTIVE_TRIGGER_FLOWS_DESCRIPTION = "Active Trigger Flows";
    public static final String DECLARED_APIKIT_FLOWS_APP_NAME = "declared-apikit-flows";
    public static final String DECLARED_APIKIT_FLOWS_APP_DESCRIPTION = "Declared ApiKit Flows";
    public static final String ACTIVE_APIKIT_FLOWS_APP_NAME = "active-apikit-flows";
    public static final String ACTIVE_APIKIT_FLOWS_APP_DESCRIPTION = "Active Apikit Flows";
    private final boolean enabled;
    private final AtomicInteger declaredPrivateFlows = new AtomicInteger(0);
    private final AtomicInteger activePrivateFlows = new AtomicInteger(0);
    private final AtomicInteger declaredTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger activeTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger declaredApikitFlows = new AtomicInteger(0);
    private final AtomicInteger activeApikitFlows = new AtomicInteger(0);
    private final Set<String> declaredPrivateFlowNames = Collections.synchronizedSet(new HashSet());
    private final Set<String> declaredTriggerFlowNames = Collections.synchronizedSet(new HashSet());
    private final Set<String> declaredApiKitFlowNames = Collections.synchronizedSet(new HashSet());

    public DefaultFlowsSummaryStatistics(boolean isStatisticsEnabled) {
        this.enabled = isStatisticsEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int incrementDeclaredPrivateFlow(String flowName) {
        this.declaredPrivateFlowNames.add(flowName);
        return this.declaredPrivateFlows.incrementAndGet();
    }

    public int incrementActivePrivateFlow() {
        return this.activePrivateFlows.incrementAndGet();
    }

    public int incrementDeclaredTriggerFlow(String flowName) {
        this.declaredTriggerFlowNames.add(flowName);
        return this.declaredTriggerFlows.incrementAndGet();
    }

    public int incrementActiveTriggerFlow() {
        return this.activeTriggerFlows.incrementAndGet();
    }

    public int incrementDeclaredApikitFlow(String flowName) {
        this.declaredApiKitFlowNames.add(flowName);
        return this.declaredApikitFlows.incrementAndGet();
    }

    public int incrementActiveApikitFlow() {
        return this.activeApikitFlows.incrementAndGet();
    }

    public int decrementActiveTriggerFlow() {
        return this.activeTriggerFlows.decrementAndGet();
    }

    public int decrementActivePrivateFlow() {
        return this.activePrivateFlows.decrementAndGet();
    }

    public int decrementActiveApikitFlow() {
        return this.activeApikitFlows.decrementAndGet();
    }

    public int decrementDeclaredPrivateFlow(String flowName) {
        this.declaredPrivateFlowNames.remove(flowName);
        return this.declaredPrivateFlows.decrementAndGet();
    }

    public int decrementDeclaredTriggerFlow(String flowName) {
        this.declaredTriggerFlowNames.remove(flowName);
        return this.declaredTriggerFlows.decrementAndGet();
    }

    public int decrementDeclaredApikitFlow(String flowName) {
        this.declaredApiKitFlowNames.remove(flowName);
        return this.declaredApikitFlows.decrementAndGet();
    }

    @Override
    public int getDeclaredPrivateFlows() {
        return this.declaredPrivateFlows.get();
    }

    @Override
    public int getActivePrivateFlows() {
        return this.activePrivateFlows.get();
    }

    @Override
    public int getDeclaredTriggerFlows() {
        return this.declaredTriggerFlows.get();
    }

    @Override
    public int getActiveTriggerFlows() {
        return this.activeTriggerFlows.get();
    }

    @Override
    public int getDeclaredApikitFlows() {
        return this.declaredApikitFlows.get();
    }

    @Override
    public int getActiveApikitFlows() {
        return this.activeApikitFlows.get();
    }

    @Override
    public void trackUsingMeterProvider(ArtifactMeterProvider meterProvider) {
        String artifactId = meterProvider.getArtifactId();
        Meter meter = meterProvider.getMeterBuilder(FLOWS_SUMMARY_APP_STATISTICS_NAME).withDescription(FLOWS_SUMMARY_APP_STATISTICS_DESCRIPTION_TEMPLATE).withMeterAttribute("mule.artifact.id", artifactId).build();
        meter.counterBuilder(DECLARED_PRIVATE_FLOWS_APP_NAME).withValueSupplier(() -> this.declaredPrivateFlows.get()).withAddOperation((value, context) -> this.declaredPrivateFlows.addAndGet(value.intValue())).withIncrementAndGetOperation(stringStringMap -> this.declaredPrivateFlows.incrementAndGet()).withDescription(DECLARED_PRIVATE_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(ACTIVE_PRIVATE_FLOWS_APP_NAME).withValueSupplier(() -> this.activePrivateFlows.get()).withAddOperation((value, context) -> this.activePrivateFlows.addAndGet(value.intValue())).withIncrementAndGetOperation(stringStringMap -> this.activePrivateFlows.incrementAndGet()).withDescription(ACTIVE_PRIVATE_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(DECLARED_TRIGGER_FLOWS_APP_NAME).withValueSupplier(() -> this.declaredTriggerFlows.get()).withAddOperation((value, context) -> this.declaredTriggerFlows.addAndGet(value.intValue())).withIncrementAndGetOperation(stringStringMap -> this.declaredTriggerFlows.incrementAndGet()).withDescription(DECLARED_TRIGGER_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(ACTIVE_TRIGGER_FLOWS_NAME).withValueSupplier(() -> this.activeTriggerFlows.get()).withAddOperation((value, context) -> this.activeTriggerFlows.addAndGet(value.intValue())).withIncrementAndGetOperation(stringStringMap -> this.activeTriggerFlows.incrementAndGet()).withDescription(ACTIVE_TRIGGER_FLOWS_DESCRIPTION).build();
        meter.counterBuilder(DECLARED_APIKIT_FLOWS_APP_NAME).withValueSupplier(() -> this.declaredApikitFlows.get()).withAddOperation((value, context) -> this.declaredApikitFlows.addAndGet(value.intValue())).withIncrementAndGetOperation(stringStringMap -> this.declaredApikitFlows.incrementAndGet()).withDescription(DECLARED_APIKIT_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(ACTIVE_APIKIT_FLOWS_APP_NAME).withValueSupplier(() -> this.activeApikitFlows.get()).withAddOperation((value, context) -> this.activeApikitFlows.addAndGet(value.intValue())).withIncrementAndGetOperation(stringStringMap -> this.activeApikitFlows.incrementAndGet()).withDescription(ACTIVE_APIKIT_FLOWS_APP_DESCRIPTION).build();
    }

    public String toString() {
        return "\nFlows Summary: {\n\tFlows with event sources: {\n\t\tTotal: " + this.declaredTriggerFlowNames.size() + ",\n\t\tFlows: " + this.declaredTriggerFlowNames + "\n\t},\n\tNumber of implementation flows generated by APIKit: {\n\t\tTotal: " + this.declaredApiKitFlowNames.size() + ",\n\t\tFlows: " + this.declaredApiKitFlowNames + "\n\t}\n}";
    }
}

