/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexExecNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.literal.LiteralRegexExecNodeGen;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.input.InputOps;
import com.oracle.truffle.regex.tregex.parser.ast.InnerLiteral;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.PreCalcResultVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.tregex.util.DebugUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public abstract class LiteralRegexExecNode
extends RegexExecNode
implements JsonConvertible {
    @Node.Child
    TruffleString.MaterializeNode materializeNode = TruffleString.MaterializeNode.create();
    @Node.Child
    LiteralRegexExecImplNode implNode;

    LiteralRegexExecNode(RegexLanguage language, RegexAST ast, LiteralRegexExecImplNode implNode) {
        super(language, ast.getSource(), ast.getFlags().isEitherUnicode());
        this.implNode = (LiteralRegexExecImplNode)this.insert(implNode);
    }

    @Override
    protected final String getEngineLabel() {
        return "literal:" + this.implNode.getImplName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("method", this.implNode.getImplName()), Json.prop("literal", DebugUtil.escapeString(this.implNode.getLiteral())), Json.prop("factory", this.implNode.resultFactory));
    }

    @Override
    public abstract RegexResult execute(VirtualFrame var1, TruffleString var2, int var3, int var4, int var5, int var6);

    @Specialization
    RegexResult doTString(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo) {
        this.materializeNode.execute((AbstractTruffleString)input, this.getEncoding().getTStringEncoding());
        return this.implNode.execute(input, fromIndex, toIndex, regionFrom, regionTo, this.getEncoding());
    }

    static LiteralRegexExecNode create(RegexLanguage language, RegexAST ast, LiteralRegexExecImplNode implNode) {
        return LiteralRegexExecNodeGen.create(language, ast, implNode);
    }

    static abstract class LiteralRegexExecImplNode
    extends Node {
        private final PreCalculatedResultFactory resultFactory;

        protected LiteralRegexExecImplNode(PreCalcResultVisitor preCalcResultVisitor) {
            this.resultFactory = preCalcResultVisitor.isBooleanMatch() ? null : preCalcResultVisitor.getResultFactory();
        }

        abstract String getImplName();

        String getLiteral() {
            return "";
        }

        final RegexResult createFromStart(int start) {
            return this.resultFactory == null ? RegexResult.getBooleanMatchInstance() : this.resultFactory.createFromStart(start);
        }

        final RegexResult createFromEnd(int end) {
            return this.resultFactory == null ? RegexResult.getBooleanMatchInstance() : this.resultFactory.createFromEnd(end);
        }

        abstract RegexResult execute(TruffleString var1, int var2, int var3, int var4, int var5, Encodings.Encoding var6);
    }

    public static abstract class RegionMatches
    extends LiteralRegexExecWithRegionMatchNode {
        public RegionMatches(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "regionMatches";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            if (InputOps.regionEquals(input, this.literal, this.literalLength, encoding, fromIndex, toIndex, this.regionEqualsNode)) {
                return this.createFromStart(fromIndex);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class Equals
    extends LiteralRegexExecWithRegionMatchNode {
        public Equals(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "equals";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            if (fromIndex == regionFrom && toIndex == regionTo && toIndex - fromIndex == this.literalLength && InputOps.regionEquals(input, this.literal, this.literalLength, encoding, fromIndex, toIndex, this.regionEqualsNode)) {
                return this.createFromStart(fromIndex);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class EndsWith
    extends LiteralRegexExecWithRegionMatchNode {
        private final boolean sticky;

        public EndsWith(PreCalcResultVisitor preCalcResultVisitor, boolean sticky) {
            super(preCalcResultVisitor);
            this.sticky = sticky;
        }

        @Override
        protected String getImplName() {
            return "endsWith";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            int matchStart = regionTo - this.literalLength;
            if (toIndex == regionTo && (this.sticky ? fromIndex == matchStart : fromIndex <= matchStart) && InputOps.regionEquals(input, this.literal, this.literalLength, encoding, matchStart, toIndex, this.regionEqualsNode)) {
                return this.createFromEnd(regionTo);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class StartsWith
    extends LiteralRegexExecWithRegionMatchNode {
        public StartsWith(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "startsWith";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            if (fromIndex == regionFrom && InputOps.regionEquals(input, this.literal, this.literalLength, encoding, fromIndex, toIndex, this.regionEqualsNode)) {
                return this.createFromStart(regionFrom);
            }
            return RegexResult.getNoMatchInstance();
        }
    }

    public static abstract class LiteralRegexExecWithRegionMatchNode
    extends NonEmptyLiteralRegexExecNode {
        @Node.Child
        TruffleString.RegionEqualByteIndexNode regionEqualsNode = TruffleString.RegionEqualByteIndexNode.create();

        public LiteralRegexExecWithRegionMatchNode(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }
    }

    public static abstract class IndexOfString
    extends NonEmptyLiteralRegexExecNode {
        @Node.Child
        TruffleString.ByteIndexOfStringNode indexOfStringNode = TruffleString.ByteIndexOfStringNode.create();

        public IndexOfString(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
        }

        @Override
        protected String getImplName() {
            return "indexOfString";
        }

        @Specialization
        protected RegexResult run(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            int start = InputOps.indexOf(input, fromIndex, toIndex, this.literal, encoding, this.indexOfStringNode);
            if (start < 0) {
                return RegexResult.getNoMatchInstance();
            }
            return this.createFromStart(start);
        }
    }

    static abstract class NonEmptyLiteralRegexExecNode
    extends LiteralRegexExecImplNode {
        protected final int literalLength;
        protected final InnerLiteral literal;

        NonEmptyLiteralRegexExecNode(PreCalcResultVisitor preCalcResultVisitor) {
            super(preCalcResultVisitor);
            this.literalLength = preCalcResultVisitor.getLiteral().encodedLength();
            this.literal = new InnerLiteral(preCalcResultVisitor.getLiteral(), preCalcResultVisitor.getMask(), 0);
        }

        @Override
        protected String getLiteral() {
            return this.literal.getLiteral().toString();
        }
    }

    public static final class EmptyEquals
    extends EmptyLiteralRegexExecNode {
        public EmptyEquals(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
        }

        @Override
        protected String getImplName() {
            return "emptyEquals";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            return regionFrom == regionTo && !this.mustAdvance ? this.createFromStart(regionFrom) : RegexResult.getNoMatchInstance();
        }
    }

    public static final class EmptyEndsWith
    extends EmptyLiteralRegexExecNode {
        private final boolean sticky;

        public EmptyEndsWith(PreCalcResultVisitor preCalcResultVisitor, boolean sticky, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
            this.sticky = sticky;
        }

        @Override
        protected String getImplName() {
            return "emptyEndsWith";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            if (this.sticky && fromIndex < regionTo || this.mustAdvance && fromIndex == regionTo) {
                return RegexResult.getNoMatchInstance();
            }
            return this.createFromEnd(regionTo);
        }
    }

    public static final class EmptyStartsWith
    extends EmptyLiteralRegexExecNode {
        public EmptyStartsWith(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
        }

        @Override
        protected String getImplName() {
            return "emptyStartsWith";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            return fromIndex == regionFrom && !this.mustAdvance ? this.createFromStart(regionFrom) : RegexResult.getNoMatchInstance();
        }
    }

    public static final class EmptyIndexOf
    extends EmptyLiteralRegexExecNode {
        public EmptyIndexOf(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor, mustAdvance);
        }

        @Override
        protected String getImplName() {
            return "emptyIndexOf";
        }

        @Override
        protected RegexResult execute(TruffleString input, int fromIndex, int toIndex, int regionFrom, int regionTo, Encodings.Encoding encoding) {
            if (this.mustAdvance) {
                if (fromIndex < regionTo) {
                    return this.createFromStart(fromIndex + 1);
                }
                return RegexResult.getNoMatchInstance();
            }
            return this.createFromStart(fromIndex);
        }
    }

    static abstract class EmptyLiteralRegexExecNode
    extends LiteralRegexExecImplNode {
        protected final boolean mustAdvance;

        EmptyLiteralRegexExecNode(PreCalcResultVisitor preCalcResultVisitor, boolean mustAdvance) {
            super(preCalcResultVisitor);
            this.mustAdvance = mustAdvance;
        }
    }
}

