/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.csv.reader.parser;

import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.module.core.csv.reader.parser.CSVSettings;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001I4Aa\u0004\t\u0001G!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003-\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"B \u0001\t\u0003\u0001\u0005\"B*\u0001\t\u0003!\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B/\u0001\t\u0003q\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u00023\u0001\t\u0003)\u0007\"B4\u0001\t\u0003A\u0007\"\u00026\u0001\t\u0003Y\u0007\"B7\u0001\t\u0013q\u0007\"B8\u0001\t\u0003\u0001(!E\"T-N+G\u000f^5oONDU\r\u001c9fe*\u0011\u0011CE\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005M!\u0012A\u0002:fC\u0012,'O\u0003\u0002\u0016-\u0005\u00191m\u001d<\u000b\u0005]A\u0012\u0001B2pe\u0016T!!\u0007\u000e\u0002\r5|G-\u001e7f\u0015\tYB$\u0001\u0002we)\u0011QDH\u0001\u0006o\u0016\fg/\u001a\u0006\u0003?\u0001\nA!\\;mK*\t\u0011%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\f1bY:w'\u0016$H/\u001b8hgV\tA\u0006\u0005\u0002.]5\t\u0001#\u0003\u00020!\tY1i\u0015,TKR$\u0018N\\4t\u00031\u00197O^*fiRLgnZ:!\u0003=\u0019X\r\u001e;j]\u001e\u001c8+\u001a:wS\u000e,\u0007CA\u001a9\u001b\u0005!$BA\u001b7\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u000e\u000e\u0002\u000b5|G-\u001a7\n\u0005e\"$aD*fiRLgnZ:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\raTH\u0010\t\u0003[\u0001AQA\u000b\u0003A\u00021BQ!\r\u0003A\u0002I\n\u0001\"\u001e8fg\u000e\f\u0007/\u001a\u000b\u0004\u00032s\u0005C\u0001\"J\u001d\t\u0019u\t\u0005\u0002EM5\tQI\u0003\u0002GE\u00051AH]8pizJ!\u0001\u0013\u0014\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011\u001aBQ!T\u0003A\u0002\u0005\u000bQA^1mk\u0016DQaT\u0003A\u0002A\u000b\u0001\"[:Rk>$X\r\u001a\t\u0003KEK!A\u0015\u0014\u0003\u000f\t{w\u000e\\3b]\u00061\"/Z9vSJ,7/R:dCB,\u0017J\\)v_R,G\r\u0006\u0002Q+\")aK\u0002a\u0001/\u0006!1\r[1s!\t)\u0003,\u0003\u0002ZM\t!1\t[1s\u00039\u0011X-];je\u0016\u001cXi]2ba\u0016$\"\u0001\u0015/\t\u000bY;\u0001\u0019A,\u0002\u0019%\u001cH*\u001b8f\u000b:$\u0017N\\4\u0015\u0005A{\u0006\"\u00021\t\u0001\u00049\u0016!A2\u0002\u0017%\u001c\u0018+^8uK\u000eC\u0017M\u001d\u000b\u0003!\u000eDQ\u0001Y\u0005A\u0002]\u000b\u0011#[:D_2,XN\\*fa\u0006\u0014\u0018\r^8s)\t\u0001f\rC\u0003a\u0015\u0001\u0007q+\u0001\u0007jg\u0016\u001b8-\u00199f\u0007\"\f'\u000f\u0006\u0002QS\")\u0001m\u0003a\u0001/\u0006!Rm]2ba\u0016,f.];pi\u0016$7\u000b\u001e:j]\u001e$\"!\u00117\t\u000b5c\u0001\u0019A!\u0002%\u0005dw/Y=t\u000bN\u001c\u0017\r]3Rk>$Xm\u001d\u000b\u0002!\u0006\u0011Rm]2ba\u0016\fVo\u001c;fIN#(/\u001b8h)\t\t\u0015\u000fC\u0003N\u001d\u0001\u0007\u0011\t")
public class CSVSettingsHelper {
    private final CSVSettings csvSettings;
    private final SettingsService settingsService;

    public CSVSettings csvSettings() {
        return this.csvSettings;
    }

    public String unescape(String value, boolean isQuoted) {
        StringBuilder result = new StringBuilder();
        char[] array = value.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            StringBuilder stringBuilder;
            boolean isEscapeAndNextIsQuote;
            char c = array[i];
            boolean bl = isEscapeAndNextIsQuote = this.isEscapeChar(c) && i + 1 < array.length && this.needsEscape$1(array[i + 1], isQuoted);
            if (!isEscapeAndNextIsQuote) {
                stringBuilder = result.append(c);
                continue;
            }
            result.append(array[i + 1]);
            ++i;
            stringBuilder = BoxedUnit.UNIT;
        }
        return result.toString();
    }

    public boolean requiresEscapeInQuoted(char c) {
        return this.csvSettings().requiresEscapeInQuoted(c);
    }

    public boolean requiresEscape(char c) {
        return this.csvSettings().requiresEscape(c);
    }

    public boolean isLineEnding(char c) {
        return this.csvSettings().isLineEnding(c);
    }

    public boolean isQuoteChar(char c) {
        return this.csvSettings().isQuoteChar(c);
    }

    public boolean isColumnSeparator(char c) {
        return this.csvSettings().isColumnSeparator(c);
    }

    public boolean isEscapeChar(char c) {
        return this.csvSettings().isEscapeChar(c);
    }

    public String escapeUnquotedString(String value) {
        StringBuilder result = new StringBuilder();
        char maybeEscape = this.csvSettings().escape();
        for (int i = 0; i < value.length(); ++i) {
            Object object;
            char c = value.charAt(i);
            if (maybeEscape != '\u0000') {
                boolean needsEscaping;
                boolean bl = needsEscaping = this.isEscapeChar(c) || this.isColumnSeparator(c) || this.isLineEnding(c) || this.isQuoteChar(c) && this.alwaysEscapeQuotes();
                object = needsEscaping ? result.append(maybeEscape) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean alwaysEscapeQuotes() {
        return this.settingsService.csvWriter().alwaysEscapeQuotesInCSV();
    }

    public String escapeQuotedString(String value) {
        StringBuilder result = new StringBuilder();
        char maybeEscape = this.csvSettings().escape();
        for (int i = 0; i < value.length(); ++i) {
            Object object;
            char c = value.charAt(i);
            if (maybeEscape != '\u0000') {
                boolean needsEscaping;
                boolean bl = needsEscaping = this.isEscapeChar(c) || this.isQuoteChar(c);
                object = needsEscaping ? result.append(maybeEscape) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            result.append(c);
        }
        return result.toString();
    }

    private final boolean needsEscape$1(char c, boolean isQuoted$1) {
        if (isQuoted$1) {
            return this.requiresEscapeInQuoted(c);
        }
        return this.requiresEscape(c);
    }

    public CSVSettingsHelper(CSVSettings csvSettings, SettingsService settingsService) {
        this.csvSettings = csvSettings;
        this.settingsService = settingsService;
    }
}

