/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.config;

import com.oracle.truffle.js.scriptengine.GraalJSEngineFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.service.scheduler.ThreadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerThreadPoolsConfig
implements SchedulerPoolsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainerThreadPoolsConfig.class);
    public static final String PROP_PREFIX = "org.mule.runtime.scheduler.";
    private static final Pattern MAX_MIN_PATTERN = Pattern.compile("(max|min)");
    private static final String NUMBER_OR_VAR_REGEXP = "([0-9]+(\\.[0-9]+)?)|cores|mem";
    private static final String FORMULA_FUNCTION_PARAM = "(([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*";
    private static final Pattern POOLSIZE_PATTERN = Pattern.compile("^(([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*|max\\s*\\(\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*,\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*\\)|min\\s*\\(\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*,\\s*((([0-9]+(\\.[0-9]+)?)|cores|mem)?(\\s*[-+\\/*\\(\\)]\\s*(([0-9]+(\\.[0-9]+)?)|cores|mem)?)*)?\\s*\\)$");
    public static final String SCHEDULER_POOLS_CONFIG_FILE_PROPERTY = "mule.schedulerPools.configFile";
    public static final String CONF_FILE_NAME = "conf" + File.separator + "scheduler-pools.conf";
    public static final String STRATEGY_PROPERTY_NAME = "org.mule.runtime.scheduler." + SchedulerPoolStrategy.class.getSimpleName();
    public static final String CPU_LIGHT_PREFIX = "org.mule.runtime.scheduler." + ThreadType.CPU_LIGHT.getName();
    public static final String IO_PREFIX = "org.mule.runtime.scheduler." + ThreadType.IO.getName();
    public static final String CPU_INTENSIVE_PREFIX = "org.mule.runtime.scheduler." + ThreadType.CPU_INTENSIVE.getName();
    public static final String UBER_PREFIX = "org.mule.runtime.scheduler.uber";
    public static final String THREAD_POOL = "threadPool";
    public static final String THREAD_POOL_SIZE = "threadPool.size";
    public static final String CPU_INTENSIVE_THREAD_POOL_SIZE = CPU_INTENSIVE_PREFIX + ".threadPool.size";
    public static final String CPU_LIGHT_THREAD_POOL_SIZE = CPU_LIGHT_PREFIX + ".threadPool.size";
    public static final String THREAD_POOL_SIZE_MAX = "threadPool.maxSize";
    public static final String UBER_THREAD_POOL_SIZE_MAX = "org.mule.runtime.scheduler.uber.threadPool.maxSize";
    public static final String IO_THREAD_POOL_SIZE_MAX = IO_PREFIX + ".threadPool.maxSize";
    public static final String THREAD_POOL_SIZE_CORE = "threadPool.coreSize";
    public static final String UBER_THREAD_POOL_SIZE_CORE = "org.mule.runtime.scheduler.uber.threadPool.coreSize";
    public static final String IO_THREAD_POOL_SIZE = IO_PREFIX + ".threadPool.coreSize";
    public static final String THREAD_POOL_KEEP_ALIVE = "threadPool.threadKeepAlive";
    public static final String UBER_THREAD_POOL_KEEP_ALIVE = "org.mule.runtime.scheduler.uber.threadPool.threadKeepAlive";
    public static final String IO_THERAD_POOL_KEEP_ALIVE = IO_PREFIX + ".threadPool.threadKeepAlive";
    public static final String WORK_QUEUE = "workQueue";
    public static final String WORK_QUEUE_SIZE = "workQueue.size";
    public static final String UBER_QUEUE_SIZE = "org.mule.runtime.scheduler.uber.workQueue.size";
    public static final String CPU_INTENSIVE_WORK_QUEUE_SIZE = CPU_INTENSIVE_PREFIX + ".workQueue.size";
    public static final String IO_WORK_QUEUE_SIZE = IO_PREFIX + ".workQueue.size";
    public static final String CPU_LIGHT_WORK_QUEUE_SIZE = CPU_LIGHT_PREFIX + ".workQueue.size";
    private static int CORES = Runtime.getRuntime().availableProcessors();
    private static long MEM = Runtime.getRuntime().maxMemory() / 1024L;
    public static final int BIG_POOL_DEFAULT_SIZE = (int)Math.max(2L, (long)CORES + (MEM - 245760L) / 5120L);
    private SchedulerPoolStrategy schedulerPoolStrategy = SchedulerPoolStrategy.UBER;
    private long gracefulShutdownTimeout = 15000L;
    private Integer cpuLightQueueSize = null;
    private Integer cpuLightPoolSize = null;
    private Integer ioQueueSize = null;
    private Integer ioCorePoolSize = null;
    private Integer ioMaxPoolSize = null;
    private Long ioKeepAlive = null;
    private Integer uberQueueSize = 0;
    private Integer uberCorePoolSize = CORES;
    private Integer uberMaxPoolSize = BIG_POOL_DEFAULT_SIZE;
    private Long uberKeepAlive = 30000L;
    private Integer cpuIntensiveQueueSize = null;
    private Integer cpuIntensivePoolSize = null;

    public static ContainerThreadPoolsConfig loadThreadPoolsConfig() throws MuleException {
        ContainerThreadPoolsConfig containerThreadPoolsConfig;
        File muleHome;
        ContainerThreadPoolsConfig config = new ContainerThreadPoolsConfig();
        String overriddenConfigFileName = System.getProperty(SCHEDULER_POOLS_CONFIG_FILE_PROPERTY);
        if (overriddenConfigFileName != null) {
            ContainerThreadPoolsConfig containerThreadPoolsConfig2;
            block28: {
                File overriddenConfigFile = new File(overriddenConfigFileName);
                if (overriddenConfigFile.exists()) {
                    ContainerThreadPoolsConfig containerThreadPoolsConfig3;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Loading thread pools configuration from " + overriddenConfigFile.getPath());
                    }
                    FileInputStream configIs = new FileInputStream(overriddenConfigFile);
                    try {
                        containerThreadPoolsConfig3 = ContainerThreadPoolsConfig.loadProperties(config, configIs);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                configIs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new DefaultMuleException((Throwable)e);
                        }
                    }
                    configIs.close();
                    return containerThreadPoolsConfig3;
                }
                InputStream configIs = new URL(overriddenConfigFileName).openStream();
                try {
                    containerThreadPoolsConfig2 = ContainerThreadPoolsConfig.loadProperties(config, configIs);
                    if (configIs == null) break block28;
                }
                catch (Throwable throwable) {
                    try {
                        if (configIs != null) {
                            try {
                                configIs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new DefaultMuleException((Throwable)e);
                    }
                }
                configIs.close();
            }
            return containerThreadPoolsConfig2;
        }
        File file = muleHome = System.getProperty("mule.home") != null ? new File(System.getProperty("mule.home")) : null;
        if (muleHome == null) {
            LOGGER.info("No mule.home defined. Using default values for thread pools.");
            return config;
        }
        File defaultConfigFile = new File(muleHome, CONF_FILE_NAME);
        if (!defaultConfigFile.exists()) {
            LOGGER.info("No thread pools config file found. Using default values.");
            return config;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading thread pools configuration from " + defaultConfigFile.getPath());
        }
        FileInputStream configIs = new FileInputStream(defaultConfigFile);
        try {
            containerThreadPoolsConfig = ContainerThreadPoolsConfig.loadProperties(config, configIs);
        }
        catch (Throwable throwable) {
            try {
                try {
                    configIs.close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
        configIs.close();
        return containerThreadPoolsConfig;
    }

    private static ContainerThreadPoolsConfig loadProperties(ContainerThreadPoolsConfig config, InputStream configIs) throws MuleException {
        Properties properties = new Properties();
        try {
            properties.load(configIs);
        }
        catch (IOException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        ScriptEngineManager manager = SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_11) ? new ScriptEngineManager(GraalJSEngineFactory.class.getClassLoader()) : new ScriptEngineManager();
        String engineName = "js";
        ScriptEngine engine = manager.getEngineByName(engineName);
        if (engine == null) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"No 'js' script engine found. It is required to parse the config in 'conf/scheduler-pools.conf'"));
        }
        engine.put("cores", CORES);
        engine.put("mem", MEM);
        SchedulerPoolStrategy schedulerPoolStrategy = ContainerThreadPoolsConfig.resolveSchedulerPoolStrategy(properties);
        config.setSchedulerPoolStrategy(schedulerPoolStrategy, true);
        ContainerThreadPoolsConfig.resolveNumber(properties, "org.mule.runtime.scheduler.gracefulShutdownTimeout", true).ifPresent(v -> config.setGracefulShutdownTimeout(v));
        if (schedulerPoolStrategy == SchedulerPoolStrategy.UBER) {
            ContainerThreadPoolsConfig.resolveExpression(properties, UBER_THREAD_POOL_SIZE_CORE, engine, false).ifPresent(v -> config.setUberCorePoolSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, UBER_THREAD_POOL_SIZE_MAX, engine, false).ifPresent(v -> config.setUberMaxPoolSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, UBER_QUEUE_SIZE, engine, true).ifPresent(v -> config.setUberQueueSize(v));
            ContainerThreadPoolsConfig.resolveNumber(properties, UBER_THREAD_POOL_KEEP_ALIVE, true).ifPresent(v -> config.setUberKeepAlive(v));
        } else if (schedulerPoolStrategy == SchedulerPoolStrategy.DEDICATED) {
            ContainerThreadPoolsConfig.resolveExpression(properties, CPU_LIGHT_THREAD_POOL_SIZE, engine, false).ifPresent(v -> config.setCpuLightPoolSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, CPU_LIGHT_WORK_QUEUE_SIZE, engine, true).ifPresent(v -> config.setCpuLightQueueSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, IO_THREAD_POOL_SIZE, engine, false).ifPresent(v -> config.setIoCorePoolSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, IO_THREAD_POOL_SIZE_MAX, engine, false).ifPresent(v -> config.setIoMaxPoolSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, IO_WORK_QUEUE_SIZE, engine, true).ifPresent(v -> config.setIoQueueSize(v));
            ContainerThreadPoolsConfig.resolveNumber(properties, IO_THERAD_POOL_KEEP_ALIVE, true).ifPresent(v -> config.setIoKeepAlive(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, CPU_INTENSIVE_THREAD_POOL_SIZE, engine, false).ifPresent(v -> config.setCpuIntensivePoolSize(v));
            ContainerThreadPoolsConfig.resolveExpression(properties, CPU_INTENSIVE_WORK_QUEUE_SIZE, engine, true).ifPresent(v -> config.setCpuIntensiveQueueSize(v));
        } else {
            throw new IllegalArgumentException("Unknown pool strategy " + schedulerPoolStrategy);
        }
        return config;
    }

    private static SchedulerPoolStrategy resolveSchedulerPoolStrategy(Properties properties) throws ConfigurationException {
        String strategyName = ContainerThreadPoolsConfig.resolvePropertyValue(properties, STRATEGY_PROPERTY_NAME);
        if (strategyName == null) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Property '%s' was not specified in file '%s'", STRATEGY_PROPERTY_NAME, CONF_FILE_NAME)));
        }
        try {
            return SchedulerPoolStrategy.valueOf((String)strategyName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("There's no %s named '%s'", SchedulerPoolStrategy.class.getSimpleName(), strategyName)));
        }
    }

    private static OptionalLong resolveNumber(Properties properties, String propName, boolean allowZero) throws MuleException {
        if (!properties.containsKey(propName)) {
            LOGGER.warn("No property '{}' found in config file. Using default value.", (Object)propName);
            return OptionalLong.empty();
        }
        String property = properties.getProperty(propName);
        try {
            long result = Long.parseLong(property);
            ContainerThreadPoolsConfig.validateNumber(propName, result, allowZero);
            return OptionalLong.of(result);
        }
        catch (NumberFormatException e) {
            throw new DefaultMuleException(propName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static OptionalInt resolveExpression(Properties properties, String propName, ScriptEngine engine, boolean allowZero) throws MuleException {
        String property = ContainerThreadPoolsConfig.resolvePropertyValue(properties, propName);
        if (property == null) {
            LOGGER.warn("No property '{}' found in config file. Using default value.", (Object)propName);
            return OptionalInt.empty();
        }
        if (!POOLSIZE_PATTERN.matcher(property).matches()) {
            throw new DefaultMuleException(propName + ": Expression not valid");
        }
        property = MAX_MIN_PATTERN.matcher(property).replaceAll("Math.$1");
        try {
            int result = ((Number)engine.eval(property)).intValue();
            ContainerThreadPoolsConfig.validateNumber(propName, result, allowZero);
            return OptionalInt.of(result);
        }
        catch (ScriptException e) {
            throw new DefaultMuleException(propName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    private static String resolvePropertyValue(Properties properties, String propName) {
        String property = null;
        String sysPropOverride = System.getProperty(propName);
        if (sysPropOverride != null) {
            LOGGER.debug("Found system property override for '{}' with value '{}'", (Object)propName, (Object)sysPropOverride);
            property = sysPropOverride.trim().toLowerCase();
        } else if (properties.containsKey(propName)) {
            property = properties.getProperty(propName).trim().toLowerCase();
        }
        return property;
    }

    private static void validateNumber(String propName, long result, boolean allowZero) throws MuleException {
        if (allowZero) {
            if (result < 0L) {
                throw new DefaultMuleException(propName + ": Value has to be greater than or equal to 0");
            }
        } else if (result <= 0L) {
            throw new DefaultMuleException(propName + ": Value has to be greater than 0");
        }
    }

    private ContainerThreadPoolsConfig() {
    }

    public OptionalLong getGracefulShutdownTimeout() {
        return OptionalLong.of(this.gracefulShutdownTimeout);
    }

    private void setGracefulShutdownTimeout(long gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
    }

    public SchedulerPoolStrategy getSchedulerPoolStrategy() {
        return this.schedulerPoolStrategy;
    }

    public void setSchedulerPoolStrategy(SchedulerPoolStrategy schedulerPoolStrategy) {
        this.setSchedulerPoolStrategy(schedulerPoolStrategy, false);
    }

    public void setSchedulerPoolStrategy(SchedulerPoolStrategy schedulerPoolStrategy, boolean initDefaults) {
        this.schedulerPoolStrategy = schedulerPoolStrategy;
        if (initDefaults) {
            if (schedulerPoolStrategy == SchedulerPoolStrategy.DEDICATED) {
                this.cpuLightQueueSize = 0;
                this.cpuLightPoolSize = 2 * CORES;
                this.ioQueueSize = 0;
                this.ioCorePoolSize = CORES;
                this.ioMaxPoolSize = BIG_POOL_DEFAULT_SIZE;
                this.ioKeepAlive = 30000L;
                this.cpuIntensiveQueueSize = 2 * CORES;
                this.cpuIntensivePoolSize = 2 * CORES;
                this.uberQueueSize = null;
                this.uberMaxPoolSize = null;
                this.uberCorePoolSize = null;
                this.uberKeepAlive = null;
            } else {
                this.uberQueueSize = 0;
                this.uberCorePoolSize = CORES;
                this.uberMaxPoolSize = BIG_POOL_DEFAULT_SIZE;
                this.uberKeepAlive = 30000L;
                this.cpuLightPoolSize = null;
                this.cpuLightQueueSize = null;
                this.ioMaxPoolSize = null;
                this.ioCorePoolSize = null;
                this.ioQueueSize = null;
                this.ioKeepAlive = null;
                this.cpuIntensivePoolSize = null;
                this.cpuIntensiveQueueSize = null;
            }
        }
    }

    public OptionalInt getUberCorePoolSize() {
        return this.ofNullable(this.uberCorePoolSize);
    }

    public void setUberCorePoolSize(Integer uberCorePoolSize) {
        this.assertUberStrategy(UBER_THREAD_POOL_SIZE_CORE);
        this.uberCorePoolSize = uberCorePoolSize;
    }

    public OptionalInt getUberMaxPoolSize() {
        return this.nullableMax(this.uberCorePoolSize, this.uberMaxPoolSize);
    }

    public void setUberMaxPoolSize(Integer uberMaxPoolSize) {
        this.assertUberStrategy(UBER_THREAD_POOL_SIZE_MAX);
        this.uberMaxPoolSize = uberMaxPoolSize;
    }

    public OptionalInt getUberQueueSize() {
        return this.ofNullable(this.uberQueueSize);
    }

    public void setUberQueueSize(Integer uberQueueSize) {
        this.assertUberStrategy(UBER_QUEUE_SIZE);
        this.uberQueueSize = uberQueueSize;
    }

    public OptionalLong getUberKeepAlive() {
        return this.ofNullable(this.uberKeepAlive);
    }

    public void setUberKeepAlive(Long uberKeepAlive) {
        this.assertUberStrategy(UBER_THREAD_POOL_KEEP_ALIVE);
        this.uberKeepAlive = uberKeepAlive;
    }

    public OptionalInt getCpuLightPoolSize() {
        return this.ofNullable(this.cpuLightPoolSize);
    }

    private void setCpuLightPoolSize(int cpuLightPoolSize) {
        this.assertDedicatedStrategy(CPU_LIGHT_THREAD_POOL_SIZE);
        this.cpuLightPoolSize = cpuLightPoolSize;
    }

    public OptionalInt getCpuLightQueueSize() {
        return this.ofNullable(this.cpuLightQueueSize);
    }

    private void setCpuLightQueueSize(int cpuLightQueueSize) {
        this.assertDedicatedStrategy(CPU_LIGHT_WORK_QUEUE_SIZE);
        this.cpuLightQueueSize = cpuLightQueueSize;
    }

    public OptionalInt getIoCorePoolSize() {
        return this.ofNullable(this.ioCorePoolSize);
    }

    private void setIoCorePoolSize(int ioCorePoolSize) {
        this.assertDedicatedStrategy(IO_THREAD_POOL_SIZE);
        this.ioCorePoolSize = ioCorePoolSize;
    }

    public OptionalInt getIoMaxPoolSize() {
        return this.nullableMax(this.ioCorePoolSize, this.ioMaxPoolSize);
    }

    private void setIoMaxPoolSize(int ioMaxPoolSize) {
        this.assertDedicatedStrategy(IO_THREAD_POOL_SIZE_MAX);
        this.ioMaxPoolSize = ioMaxPoolSize;
    }

    public OptionalInt getIoQueueSize() {
        return this.ofNullable(this.ioQueueSize);
    }

    private void setIoQueueSize(int ioQueueSize) {
        this.assertDedicatedStrategy(IO_WORK_QUEUE_SIZE);
        this.ioQueueSize = ioQueueSize;
    }

    public OptionalLong getIoKeepAlive() {
        return this.ofNullable(this.ioKeepAlive);
    }

    private void setIoKeepAlive(long ioKeepAlive) {
        this.assertDedicatedStrategy(IO_THERAD_POOL_KEEP_ALIVE);
        this.ioKeepAlive = ioKeepAlive;
    }

    public OptionalInt getCpuIntensivePoolSize() {
        return this.ofNullable(this.cpuIntensivePoolSize);
    }

    private void setCpuIntensivePoolSize(int cpuIntensivePoolSize) {
        this.assertDedicatedStrategy(CPU_INTENSIVE_THREAD_POOL_SIZE);
        this.cpuIntensivePoolSize = cpuIntensivePoolSize;
    }

    public OptionalInt getCpuIntensiveQueueSize() {
        return this.ofNullable(this.cpuIntensiveQueueSize);
    }

    private void setCpuIntensiveQueueSize(int cpuIntensiveQueueSize) {
        this.assertDedicatedStrategy(CPU_INTENSIVE_WORK_QUEUE_SIZE);
        this.cpuIntensiveQueueSize = cpuIntensiveQueueSize;
    }

    public String getThreadNamePrefix() {
        return "[MuleRuntime].";
    }

    private OptionalInt nullableMax(Integer a, Integer b) {
        if (a == null && b == null) {
            return OptionalInt.empty();
        }
        if (a == null && b != null) {
            return OptionalInt.of(b);
        }
        if (a != null && b == null) {
            return OptionalInt.of(a);
        }
        return OptionalInt.of(Math.max(a, b));
    }

    private OptionalInt ofNullable(Integer value) {
        return value != null ? OptionalInt.of(value) : OptionalInt.empty();
    }

    private OptionalLong ofNullable(Long value) {
        return value != null ? OptionalLong.of(value) : OptionalLong.empty();
    }

    private void assertDedicatedStrategy(String propertyName) {
        this.assertStrategy(SchedulerPoolStrategy.DEDICATED, propertyName);
    }

    private void assertUberStrategy(String propertyName) {
        this.assertStrategy(SchedulerPoolStrategy.UBER, propertyName);
    }

    private void assertStrategy(SchedulerPoolStrategy expected, String propertyName) {
        if (this.schedulerPoolStrategy != expected) {
            throw new IllegalStateException((Throwable)new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Property '%s' can only be set when '%s' is '%s'. Current value is '%s'", propertyName, STRATEGY_PROPERTY_NAME, expected, this.schedulerPoolStrategy))));
        }
    }
}

