/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.impl;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public class StreamExceptionBase
extends XMLStreamException {
    final String mMsg;

    public StreamExceptionBase(String msg) {
        super(msg);
        this.mMsg = msg;
    }

    public StreamExceptionBase(Throwable th) {
        super(th.getMessage(), th);
        this.mMsg = th.getMessage();
        if (this.getCause() == null) {
            this.initCause(th);
        }
    }

    public StreamExceptionBase(String msg, Location loc) {
        super(msg, loc);
        this.mMsg = msg;
    }

    public StreamExceptionBase(String msg, Location loc, Throwable th) {
        super(msg, loc, th);
        this.mMsg = msg;
        if (th != null && this.getCause() == null) {
            this.initCause(th);
        }
    }

    @Override
    public String getMessage() {
        String locMsg = this.getLocationDesc();
        if (locMsg == null) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder(this.mMsg.length() + locMsg.length() + 20);
        sb.append(this.mMsg);
        sb.append('\n');
        sb.append(" at ");
        sb.append(locMsg);
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": " + this.getMessage();
    }

    protected String getLocationDesc() {
        Location loc = this.getLocation();
        return loc == null ? null : loc.toString();
    }
}

