/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager.jdk;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.internal.util.version.JdkVersionUtils;
import org.mule.runtime.module.extension.internal.manager.jdk.ExtensionJdkValidator;

abstract class BaseExtensionJdkValidator
implements ExtensionJdkValidator {
    protected final JdkVersionUtils.JdkVersion runningJdkVersion;
    private final String versionAsString;

    public BaseExtensionJdkValidator(JdkVersionUtils.JdkVersion runningJdkVersion) {
        this.runningJdkVersion = runningJdkVersion;
        this.versionAsString = String.valueOf(runningJdkVersion.getMajor());
    }

    @Override
    public void validateJdkSupport(ExtensionModel extensionModel) {
        if (!this.isSupported(extensionModel)) {
            this.onUnsupportedJdkVersion(extensionModel);
        }
    }

    protected String getErrorMessageFor(ExtensionModel extensionModel) {
        return String.format("Extension '%s' does not support Java %s. Supported versions are: %s", extensionModel.getName(), this.versionAsString, extensionModel.getSupportedJavaVersions());
    }

    protected abstract void onUnsupportedJdkVersion(ExtensionModel var1);

    private boolean isSupported(ExtensionModel extensionModel) {
        return extensionModel.getSupportedJavaVersions().contains(this.versionAsString);
    }
}

