/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;

public class GZIPCompressorInputStream
extends DeflaterInputStream {
    private static final int GZIP_MAGIC = 35615;
    private static final byte[] HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
    private static final int TRAILER_LENGTH = 8;
    private boolean trailerWritten = false;
    private final Buffer buffer = new Buffer();

    public GZIPCompressorInputStream(InputStream in) {
        super(new CheckedInputStream(in, new CRC32()), new Deflater(-1, true));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.getByteCountRemainder() > 0) {
            int count = Math.min(len, this.buffer.getByteCountRemainder());
            System.arraycopy(this.buffer.data, this.buffer.position, b, off, count);
            this.buffer.position += count;
            return count;
        }
        int count = super.read(b, off, len);
        if (count > 0) {
            return count;
        }
        if (count <= 0 && !this.trailerWritten) {
            this.buffer.position = 0;
            this.buffer.length = this.writeTrailer(this.buffer.data, this.buffer.position);
            this.trailerWritten = true;
            return this.read(b, off, len);
        }
        return count;
    }

    private int writeTrailer(byte[] buf, int offset) throws IOException {
        int count = this.writeInt((int)((CheckedInputStream)this.in).getChecksum().getValue(), buf, offset);
        return count += this.writeInt(this.def.getTotalIn(), buf, offset + 4);
    }

    private int writeInt(int i, byte[] buf, int offset) throws IOException {
        int count = this.writeShort(i & 0xFFFF, buf, offset);
        return count += this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
    }

    private int writeShort(int s, byte[] buf, int offset) throws IOException {
        buf[offset] = (byte)(s & 0xFF);
        buf[offset + 1] = (byte)(s >> 8 & 0xFF);
        return 2;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.def.end();
    }

    private class Buffer {
        public byte[] data = new byte[Math.max(HEADER.length, 8)];
        public int position;
        public int length;

        public Buffer() {
            System.arraycopy(HEADER, 0, this.data, 0, HEADER.length);
            this.position = 0;
            this.length = HEADER.length;
        }

        int getByteCountRemainder() {
            return this.length - this.position;
        }
    }
}

