/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractPublicNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.NumberConversion;
import com.oracle.truffle.api.strings.Stride;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringUnsafe;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilderFactory;
import com.oracle.truffle.api.strings.TruffleStringBuilderGeneric;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF16;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF32;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF8;
import java.util.Arrays;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class TruffleStringBuilder {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    byte[] buf;
    int length;
    int codeRange;
    final TruffleString.Encoding encoding;
    int stride;
    int codePointLength;

    TruffleStringBuilder(TruffleString.Encoding encoding, int initialSize, int codeRange) {
        this.buf = new byte[initialSize];
        this.codeRange = codeRange;
        this.encoding = encoding;
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    public final int byteLength() {
        return this.length << this.encoding.naturalStride;
    }

    final void updateCodeRange(int newCodeRange) {
        this.codeRange = TSCodeRange.commonCodeRange(this.codeRange, newCodeRange);
    }

    final void appendLength(int addLength) {
        this.appendLength(addLength, addLength);
    }

    final void appendLength(int addLength, int addCodePointLength) {
        this.length += addLength;
        this.codePointLength += addCodePointLength;
    }

    public static TruffleStringBuilder create(TruffleString.Encoding encoding) {
        return TruffleStringBuilder.create(encoding, 16);
    }

    public static TruffleStringBuilder create(TruffleString.Encoding encoding, int initialCapacity) {
        if (encoding == TruffleString.Encoding.UTF_8) {
            return TruffleStringBuilder.createUTF8(initialCapacity);
        }
        if (encoding == TruffleString.Encoding.UTF_16) {
            return TruffleStringBuilder.createUTF16(initialCapacity);
        }
        if (encoding == TruffleString.Encoding.UTF_32) {
            return TruffleStringBuilder.createUTF32(initialCapacity);
        }
        return TruffleStringBuilder.createGeneric(encoding, initialCapacity);
    }

    public static TruffleStringBuilderUTF8 createUTF8() {
        return TruffleStringBuilder.createUTF8(16);
    }

    public static TruffleStringBuilderUTF8 createUTF8(int initialCapacity) {
        return new TruffleStringBuilderUTF8(initialCapacity);
    }

    public static TruffleStringBuilderUTF16 createUTF16() {
        return TruffleStringBuilder.createUTF16(16);
    }

    public static TruffleStringBuilderUTF16 createUTF16(int initialCapacity) {
        return new TruffleStringBuilderUTF16(initialCapacity);
    }

    public static TruffleStringBuilderUTF32 createUTF32() {
        return TruffleStringBuilder.createUTF32(16);
    }

    public static TruffleStringBuilderUTF32 createUTF32(int initialCapacity) {
        return new TruffleStringBuilderUTF32(initialCapacity);
    }

    static TruffleStringBuilderGeneric createGeneric(TruffleString.Encoding encoding, int initialCapacity) {
        if (encoding == TruffleString.Encoding.UTF_8 || encoding == TruffleString.Encoding.UTF_16 || encoding == TruffleString.Encoding.UTF_32) {
            throw InternalErrors.illegalArgument("use createUTF* methods for UTF encodings!");
        }
        return new TruffleStringBuilderGeneric(encoding, initialCapacity);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendByteUncached(byte value) {
        AppendByteNode.getUncached().execute(this, value);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendCharUTF16Uncached(char value) {
        AppendCharUTF16Node.getUncached().execute(this, value);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendCodePointUncached(int codepoint) {
        AppendCodePointNode.getUncached().execute(this, codepoint);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendCodePointUncached(int codepoint, int repeat) {
        AppendCodePointNode.getUncached().execute(this, codepoint, repeat);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendCodePointUncached(int codepoint, int repeat, boolean allowUTF16Surrogates) {
        AppendCodePointNode.getUncached().execute(this, codepoint, repeat, allowUTF16Surrogates);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendIntNumberUncached(int value) {
        AppendIntNumberNode.getUncached().execute(this, value);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendLongNumberUncached(long value) {
        AppendLongNumberNode.getUncached().execute(this, value);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendStringUncached(TruffleString a) {
        AppendStringNode.getUncached().execute(this, a);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendSubstringByteIndexUncached(TruffleString a, int fromByteIndex, int byteLength) {
        AppendSubstringByteIndexNode.getUncached().execute(this, a, fromByteIndex, byteLength);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendJavaStringUTF16Uncached(String a) {
        AppendJavaStringUTF16Node.getUncached().execute(this, a);
    }

    @CompilerDirectives.TruffleBoundary
    public final void appendJavaStringUTF16Uncached(String a, int fromCharIndex, int charLength) {
        AppendJavaStringUTF16Node.getUncached().execute(this, a, fromCharIndex, charLength);
    }

    @CompilerDirectives.TruffleBoundary
    public final TruffleString toStringUncached() {
        return ToStringNode.getUncached().execute(this);
    }

    final void ensureCapacityAndInflate(Node node, int appendLength, int appendStride, InlinedBranchProfile inflateProfile, InlinedBranchProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
        if (appendStride > this.stride) {
            inflateProfile.enter(node);
            this.buf = TStringOps.arraycopyOfWithStride(node, this.buf, 0, this.length, this.stride, this.buf.length >> this.stride, appendStride);
            this.stride = appendStride;
        }
        this.ensureCapacityWithStride(node, appendLength, bufferGrowProfile, errorProfile);
    }

    final void ensureCapacityWithStride(Node node, int appendLength, InlinedBranchProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
        int minimumCapacity = this.length + appendLength;
        int oldCapacity = this.buf.length >> this.stride;
        if (minimumCapacity - oldCapacity > 0) {
            bufferGrowProfile.enter(node);
            this.buf = Arrays.copyOf(this.buf, this.newCapacityWithStride(node, minimumCapacity, errorProfile));
        }
    }

    final void ensureCapacityS0(Node node, int appendLength, InlinedBranchProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
        int minimumCapacity = this.length + appendLength;
        int oldCapacity = this.buf.length;
        if (minimumCapacity - oldCapacity > 0) {
            bufferGrowProfile.enter(node);
            this.buf = Arrays.copyOf(this.buf, this.newCapacityS0(node, minimumCapacity, errorProfile));
        }
    }

    final int newCapacityS0(Node node, int minCapacity, InlinedBranchProfile errorProfile) {
        int oldLength = this.buf.length;
        int growth = minCapacity - oldLength;
        int newLength = TruffleStringBuilder.newLength(node, oldLength, growth, oldLength + 2, errorProfile);
        assert (0 < newLength && newLength <= 0x7FFFFFF7);
        return newLength;
    }

    final int newCapacityWithStride(Node node, int minCapacity, InlinedBranchProfile errorProfile) {
        int oldBytes = this.buf.length;
        int minCapacityBytes = minCapacity << this.stride;
        int growth = minCapacityBytes - oldBytes;
        int newLengthBytes = TruffleStringBuilder.newLength(node, oldBytes, growth, oldBytes + (2 << this.stride), errorProfile);
        assert (0 < newLengthBytes && newLengthBytes <= 0x7FFFFFF7);
        return newLengthBytes;
    }

    private static int newLength(Node node, int oldLength, int minGrowth, int prefGrowth, InlinedBranchProfile errorProfile) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (Integer.compareUnsigned(prefLength, 0x7FFFFFF7) <= 0) {
            return prefLength;
        }
        return TruffleStringBuilder.hugeLength(node, oldLength, minGrowth, errorProfile);
    }

    private static int hugeLength(Node node, int oldLength, int minGrowth, InlinedBranchProfile errorProfile) {
        int minLength = oldLength + minGrowth;
        if (Integer.compareUnsigned(minLength, 0x7FFFFFF7) > 0) {
            errorProfile.enter(node);
            throw InternalErrors.outOfMemory();
        }
        return 0x7FFFFFF7;
    }

    @CompilerDirectives.TruffleBoundary
    public final String toString() {
        return ToStringNode.getUncached().execute(this).toJavaStringUncached();
    }

    public static abstract class AppendByteNode
    extends AbstractPublicNode {
        AppendByteNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, byte var2);

        @Specialization
        final void append(TruffleStringBuilderUTF8 sb, byte value, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            this.appendByte(sb, value, bufferGrowProfile, errorProfile, TSCodeRange.markImprecise(TSCodeRange.getBrokenMultiByte()));
        }

        @Specialization
        final void append(TruffleStringBuilderGeneric sb, byte value, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            this.appendByte(sb, value, bufferGrowProfile, errorProfile, TSCodeRange.asciiLatinBytesNonAsciiCodeRange(sb.encoding));
        }

        private void appendByte(TruffleStringBuilder sb, byte value, InlinedBranchProfile bufferGrowProfile, InlinedBranchProfile errorProfile, int nonAsciiCodeRange) {
            sb.ensureCapacityS0(this, 1, bufferGrowProfile, errorProfile);
            sb.buf[sb.length++] = value;
            if (value < 0) {
                sb.codeRange = nonAsciiCodeRange;
            }
            ++sb.codePointLength;
        }

        @NeverDefault
        public static AppendByteNode create() {
            return TruffleStringBuilderFactory.AppendByteNodeGen.create();
        }

        public static AppendByteNode getUncached() {
            return TruffleStringBuilderFactory.AppendByteNodeGen.getUncached();
        }
    }

    public static abstract class AppendCharUTF16Node
    extends AbstractPublicNode {
        AppendCharUTF16Node() {
        }

        public abstract void execute(TruffleStringBuilder var1, char var2);

        @Specialization
        void append(TruffleStringBuilderUTF16 sb, char value, @Cached InlinedBranchProfile nonAsciiProfile, @Cached InlinedBranchProfile inflateProfile, @Cached InlinedBranchProfile bufferGrowProfile, @Cached InlinedBranchProfile errorProfile) {
            if ((sb.stride | value >>> 7) == 0) {
                sb.ensureCapacityS0(this, 1, bufferGrowProfile, errorProfile);
                sb.buf[sb.length++] = (byte)value;
            } else {
                int strideA;
                int codeRangeA;
                nonAsciiProfile.enter(this);
                if (value <= '\u007f') {
                    codeRangeA = TSCodeRange.get7Bit();
                    strideA = 0;
                } else if (value <= '\u00ff') {
                    codeRangeA = TSCodeRange.get8Bit();
                    strideA = 0;
                } else if (Encodings.isUTF16Surrogate(value)) {
                    codeRangeA = TSCodeRange.markImprecise(TSCodeRange.getBrokenMultiByte());
                    strideA = 1;
                } else {
                    codeRangeA = TSCodeRange.get16Bit();
                    strideA = 1;
                }
                sb.updateCodeRange(codeRangeA);
                sb.ensureCapacityAndInflate(this, 1, strideA, inflateProfile, bufferGrowProfile, errorProfile);
                TStringOps.writeToByteArray(sb.buf, sb.stride, sb.length++, value);
            }
            ++sb.codePointLength;
        }

        @NeverDefault
        public static AppendCharUTF16Node create() {
            return TruffleStringBuilderFactory.AppendCharUTF16NodeGen.create();
        }

        public static AppendCharUTF16Node getUncached() {
            return TruffleStringBuilderFactory.AppendCharUTF16NodeGen.getUncached();
        }
    }

    public static abstract class AppendCodePointNode
    extends AbstractPublicNode {
        AppendCodePointNode() {
        }

        public final void execute(TruffleStringBuilder sb, int codepoint) {
            this.execute(sb, codepoint, 1);
        }

        public final void execute(TruffleStringBuilder sb, int codepoint, int repeat) {
            this.execute(sb, codepoint, repeat, false);
        }

        public abstract void execute(TruffleStringBuilder var1, int var2, int var3, boolean var4);

        @Specialization
        void append(TruffleStringBuilder sb, int codepoint, int repeat, boolean allowUTF16Surrogates, @Cached AppendCodePointIntlNode appendCodePointIntlNode) {
            if (repeat < 1) {
                throw InternalErrors.illegalArgument("number of repetitions must be at least 1");
            }
            appendCodePointIntlNode.execute(this, sb, codepoint, repeat, allowUTF16Surrogates);
        }

        @NeverDefault
        public static AppendCodePointNode create() {
            return TruffleStringBuilderFactory.AppendCodePointNodeGen.create();
        }

        public static AppendCodePointNode getUncached() {
            return TruffleStringBuilderFactory.AppendCodePointNodeGen.getUncached();
        }
    }

    public static abstract class AppendIntNumberNode
    extends AbstractPublicNode {
        AppendIntNumberNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, int var2);

        @Specialization
        void doAppend(TruffleStringBuilderUTF8 sb, int value, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            int len = NumberConversion.stringLengthInt(value);
            sb.ensureCapacityS0(this, len, bufferGrowProfile, errorProfile);
            if (len == 1) {
                sb.buf[sb.length] = (byte)(48 + value);
            } else {
                NumberConversion.writeIntToBytes(this, value, sb.buf, 0, sb.length, len);
            }
            sb.length += len;
            sb.codePointLength += len;
        }

        @Specialization
        void doAppend(TruffleStringBuilderUTF16 sb, int value, @Cached @Cached.Shared InlinedConditionProfile stride0Profile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            int len = NumberConversion.stringLengthInt(value);
            sb.ensureCapacityWithStride(this, len, bufferGrowProfile, errorProfile);
            if (sb.stride == 0 && len == 1) {
                sb.buf[sb.length] = (byte)(48 + value);
            } else if (stride0Profile.profile(this, sb.stride == 0)) {
                NumberConversion.writeIntToBytes(this, value, sb.buf, 0, sb.length, len);
            } else {
                NumberConversion.writeIntToBytes(this, value, sb.buf, 1, sb.length, len);
            }
            sb.length += len;
            sb.codePointLength += len;
        }

        @Specialization
        void doAppend(TruffleStringBuilderUTF32 sb, int value, @Cached @Cached.Shared InlinedConditionProfile stride0Profile, @Cached @Cached.Exclusive InlinedConditionProfile stride1Profile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            int len = NumberConversion.stringLengthInt(value);
            sb.ensureCapacityWithStride(this, len, bufferGrowProfile, errorProfile);
            if (sb.stride == 0 && len == 1) {
                sb.buf[sb.length] = (byte)(48 + value);
            } else if (stride0Profile.profile(this, sb.stride == 0)) {
                NumberConversion.writeIntToBytes(this, value, sb.buf, 0, sb.length, len);
            } else if (stride1Profile.profile(this, sb.stride == 1)) {
                NumberConversion.writeIntToBytes(this, value, sb.buf, 1, sb.length, len);
            } else {
                NumberConversion.writeIntToBytes(this, value, sb.buf, 2, sb.length, len);
            }
            sb.length += len;
        }

        @Specialization
        void doAppend(TruffleStringBuilderGeneric sb, int value, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (!TStringGuards.is7BitCompatible(sb.encoding)) {
                throw InternalErrors.unsupportedOperation("appendIntNumber is supported on ASCII-compatible encodings only");
            }
            int len = NumberConversion.stringLengthInt(value);
            sb.ensureCapacityS0(this, len, bufferGrowProfile, errorProfile);
            NumberConversion.writeIntToBytes(this, value, sb.buf, 0, sb.length, len);
            sb.appendLength(len);
        }

        @NeverDefault
        public static AppendIntNumberNode create() {
            return TruffleStringBuilderFactory.AppendIntNumberNodeGen.create();
        }

        public static AppendIntNumberNode getUncached() {
            return TruffleStringBuilderFactory.AppendIntNumberNodeGen.getUncached();
        }
    }

    public static abstract class AppendLongNumberNode
    extends AbstractPublicNode {
        AppendLongNumberNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, long var2);

        @Specialization
        void doAppend(TruffleStringBuilderUTF8 sb, long value, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            int len = NumberConversion.stringLengthLong(value);
            sb.ensureCapacityS0(this, len, bufferGrowProfile, errorProfile);
            if (len == 1) {
                sb.buf[sb.length] = (byte)(48L + value);
            } else {
                NumberConversion.writeLongToBytes(this, value, sb.buf, 0, sb.length, len);
            }
            sb.length += len;
            sb.codePointLength += len;
        }

        @Specialization
        void doAppend(TruffleStringBuilderUTF16 sb, long value, @Cached @Cached.Shared InlinedConditionProfile stride0Profile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            int len = NumberConversion.stringLengthLong(value);
            sb.ensureCapacityWithStride(this, len, bufferGrowProfile, errorProfile);
            if (sb.stride == 0 && len == 1) {
                sb.buf[sb.length] = (byte)(48L + value);
            } else if (stride0Profile.profile(this, sb.stride == 0)) {
                NumberConversion.writeLongToBytes(this, value, sb.buf, 0, sb.length, len);
            } else {
                NumberConversion.writeLongToBytes(this, value, sb.buf, 1, sb.length, len);
            }
            sb.length += len;
            sb.codePointLength += len;
        }

        @Specialization
        void doAppend(TruffleStringBuilderUTF32 sb, long value, @Cached @Cached.Shared InlinedConditionProfile stride0Profile, @Cached @Cached.Exclusive InlinedConditionProfile stride1Profile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            int len = NumberConversion.stringLengthLong(value);
            sb.ensureCapacityWithStride(this, len, bufferGrowProfile, errorProfile);
            if (sb.stride == 0 && len == 1) {
                sb.buf[sb.length] = (byte)(48L + value);
            } else if (stride0Profile.profile(this, sb.stride == 0)) {
                NumberConversion.writeLongToBytes(this, value, sb.buf, 0, sb.length, len);
            } else if (stride1Profile.profile(this, sb.stride == 1)) {
                NumberConversion.writeLongToBytes(this, value, sb.buf, 1, sb.length, len);
            } else {
                NumberConversion.writeLongToBytes(this, value, sb.buf, 2, sb.length, len);
            }
            sb.length += len;
        }

        @Specialization
        void doAppend(TruffleStringBuilderGeneric sb, long value, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (!TStringGuards.is7BitCompatible(sb.encoding)) {
                throw InternalErrors.unsupportedOperation("appendIntNumber is supported on ASCII-compatible encodings only");
            }
            int len = NumberConversion.stringLengthLong(value);
            sb.ensureCapacityS0(this, len, bufferGrowProfile, errorProfile);
            NumberConversion.writeLongToBytes(this, value, sb.buf, 0, sb.length, len);
            sb.appendLength(len);
        }

        @NeverDefault
        public static AppendLongNumberNode create() {
            return TruffleStringBuilderFactory.AppendLongNumberNodeGen.create();
        }

        public static AppendLongNumberNode getUncached() {
            return TruffleStringBuilderFactory.AppendLongNumberNodeGen.getUncached();
        }
    }

    public static abstract class AppendStringNode
    extends AbstractPublicNode {
        AppendStringNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, AbstractTruffleString var2);

        @Specialization
        void append(TruffleStringBuilder sb, AbstractTruffleString a, @Cached AppendStringIntlNode intlNode) {
            intlNode.execute(this, sb, a);
        }

        @NeverDefault
        public static AppendStringNode create() {
            return TruffleStringBuilderFactory.AppendStringNodeGen.create();
        }

        public static AppendStringNode getUncached() {
            return TruffleStringBuilderFactory.AppendStringNodeGen.getUncached();
        }
    }

    public static abstract class AppendSubstringByteIndexNode
    extends AbstractPublicNode {
        AppendSubstringByteIndexNode() {
        }

        public abstract void execute(TruffleStringBuilder var1, AbstractTruffleString var2, int var3, int var4);

        @Specialization
        final void append(TruffleStringBuilderUTF8 sb, AbstractTruffleString a, int fromIndex, int length, @Cached @Cached.Shared TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (length == 0) {
                return;
            }
            a.checkEncoding(TruffleString.Encoding.UTF_8);
            a.boundsCheckRegionRaw(fromIndex, length);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            if (!TStringGuards.is7Bit(a.codeRange())) {
                sb.updateCodeRange(TSCodeRange.markImprecise(a.codeRange()));
            }
            sb.ensureCapacityS0(this, length, bufferGrowProfile, errorProfile);
            TStringOps.arraycopyWithStride(this, arrayA, a.offset(), 0, fromIndex, sb.buf, 0, 0, sb.length, length);
            sb.codePointLength += length;
            sb.length += length;
        }

        @Specialization
        final void append(TruffleStringBuilderUTF16 sb, AbstractTruffleString a, int fromByteIndex, int byteLength, @Cached @Cached.Shared TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared InlinedBranchProfile slowPathProfile, @Cached @Cached.Shared InlinedBranchProfile inflateProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (byteLength == 0) {
                return;
            }
            a.checkEncoding(TruffleString.Encoding.UTF_16);
            int fromIndex = TruffleString.rawIndexUTF16(fromByteIndex);
            int length = TruffleString.rawIndexUTF16(byteLength);
            a.boundsCheckRegionRaw(fromIndex, length);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            if ((a.stride() | sb.stride) == 0) {
                sb.updateCodeRange(TSCodeRange.markImprecise(a.codeRange()));
                sb.ensureCapacityS0(this, length, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(this, arrayA, a.offset(), 0, fromIndex, sb.buf, 0, 0, sb.length, length);
                sb.codePointLength += length;
            } else {
                int codePointLength;
                int codeRange;
                slowPathProfile.enter(this);
                if (a.stride() == 0) {
                    codeRange = TSCodeRange.markImprecise(a.codeRange());
                    codePointLength = length;
                } else {
                    int codeRangeA = getPreciseCodeRangeNode.execute(this, a, TruffleString.Encoding.UTF_16);
                    if (fromIndex == 0 && length == a.length()) {
                        codeRange = codeRangeA;
                        codePointLength = a.codePointLength();
                    } else if (TSCodeRange.is16Bit(codeRangeA)) {
                        assert (a.stride() == 1);
                        codeRange = TStringOps.calcStringAttributesBMP(this, arrayA, a.offset() + fromByteIndex, length);
                        codePointLength = length;
                    } else if (TSCodeRange.isValidMultiByte(codeRangeA)) {
                        long attrs = TStringOps.calcStringAttributesUTF16(this, arrayA, a.offset() + fromByteIndex, length, true);
                        codeRange = StringAttributes.getCodeRange(attrs);
                        codePointLength = StringAttributes.getCodePointLength(attrs);
                    } else {
                        long attrs = TStringOps.calcStringAttributesUTF16(this, arrayA, a.offset() + fromByteIndex, length, false);
                        codeRange = StringAttributes.getCodeRange(attrs);
                        codePointLength = StringAttributes.getCodePointLength(attrs);
                    }
                }
                sb.updateCodeRange(codeRange);
                sb.ensureCapacityAndInflate(this, a.length(), Stride.fromCodeRangeUTF16AllowImprecise(codeRange), inflateProfile, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(this, arrayA, a.offset(), a.stride(), fromIndex, sb.buf, 0, sb.stride, sb.length, length);
                sb.codePointLength += codePointLength;
            }
            sb.length += length;
        }

        @Specialization
        final void append(TruffleStringBuilderUTF32 sb, AbstractTruffleString a, int fromByteIndex, int byteLength, @Cached @Cached.Shared TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared InlinedBranchProfile slowPathProfile, @Cached @Cached.Shared InlinedBranchProfile inflateProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (byteLength == 0) {
                return;
            }
            a.checkEncoding(TruffleString.Encoding.UTF_32);
            int fromIndex = TruffleString.rawIndexUTF32(fromByteIndex);
            int length = TruffleString.rawIndexUTF32(byteLength);
            a.boundsCheckRegionRaw(fromIndex, length);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            if ((a.stride() | sb.stride) == 0) {
                sb.updateCodeRange(TSCodeRange.markImprecise(a.codeRange()));
                sb.ensureCapacityS0(this, length, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(this, arrayA, a.offset(), 0, fromIndex, sb.buf, 0, 0, sb.length, length);
            } else {
                int codeRange;
                slowPathProfile.enter(this);
                if (a.stride() == 0 || fromIndex == 0 && length == a.length() || !TSCodeRange.isMoreGeneralThan(getPreciseCodeRangeNode.execute(this, a, TruffleString.Encoding.UTF_32), sb.codeRange)) {
                    codeRange = TSCodeRange.markImprecise(a.codeRange());
                } else if (a.stride() == 1) {
                    codeRange = TStringOps.calcStringAttributesBMP(this, arrayA, a.offset() + (fromIndex << 1), length);
                } else {
                    assert (a.stride() == 2);
                    codeRange = TStringOps.calcStringAttributesUTF32(this, arrayA, a.offset() + fromByteIndex, length);
                }
                sb.updateCodeRange(codeRange);
                sb.ensureCapacityAndInflate(this, a.length(), Stride.fromCodeRangeUTF32AllowImprecise(codeRange), inflateProfile, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(this, arrayA, a.offset(), a.stride(), fromIndex, sb.buf, 0, sb.stride, sb.length, length);
            }
            sb.length += length;
        }

        @Specialization
        static void append(TruffleStringBuilderGeneric sb, AbstractTruffleString a, int fromIndex, int length, @Bind(value="this") Node node, @Cached @Cached.Exclusive TruffleString.ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Exclusive TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached TStringInternalNodes.CalcStringAttributesNode calcAttributesNode, @Cached InlinedConditionProfile calcAttrsProfile, @Cached @Cached.Exclusive InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile) {
            int codePointLength;
            int codeRange;
            if (length == 0) {
                return;
            }
            a.checkEncoding(sb.encoding);
            a.boundsCheckRegionRaw(fromIndex, length);
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            int codeRangeA = getPreciseCodeRangeNode.execute(node, a, sb.encoding);
            if (fromIndex == 0 && length == a.length()) {
                codeRange = codeRangeA;
                codePointLength = getCodePointLengthNode.execute(node, a, sb.encoding);
            } else if (TStringGuards.isFixedWidth(codeRangeA) && !TSCodeRange.isMoreGeneralThan(codeRangeA, sb.codeRange)) {
                codeRange = codeRangeA;
                codePointLength = length;
            } else if (calcAttrsProfile.profile(node, !TStringGuards.isBroken(sb.codeRange))) {
                long attrs = calcAttributesNode.execute(node, a, arrayA, a.offset(), length, a.stride(), sb.encoding, fromIndex, codeRangeA);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                codeRange = TSCodeRange.getUnknownCodeRangeForEncoding(sb.encoding.id);
                codePointLength = 0;
            }
            sb.updateCodeRange(codeRange);
            sb.ensureCapacityS0(node, length, bufferGrowProfile, errorProfile);
            TStringOps.arraycopyWithStride(node, arrayA, a.offset(), 0, fromIndex, sb.buf, 0, 0, sb.length, length);
            sb.appendLength(length, codePointLength);
        }

        @NeverDefault
        public static AppendSubstringByteIndexNode create() {
            return TruffleStringBuilderFactory.AppendSubstringByteIndexNodeGen.create();
        }

        public static AppendSubstringByteIndexNode getUncached() {
            return TruffleStringBuilderFactory.AppendSubstringByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class AppendJavaStringUTF16Node
    extends AbstractPublicNode {
        AppendJavaStringUTF16Node() {
        }

        public final void execute(TruffleStringBuilder sb, String a) {
            this.execute(sb, a, 0, a.length());
        }

        public abstract void execute(TruffleStringBuilder var1, String var2, int var3, int var4);

        @Specialization
        final void append(TruffleStringBuilderUTF16 sb, String javaString, int fromIndex, int lengthStr, @Cached InlinedBranchProfile slowPathProfile, @Cached InlinedBranchProfile inflateProfile, @Cached InlinedBranchProfile bufferGrowProfile, @Cached InlinedBranchProfile errorProfile) {
            if (lengthStr == 0) {
                return;
            }
            AbstractTruffleString.boundsCheckRegionI(fromIndex, lengthStr, javaString.length());
            byte[] arrayStr = TStringUnsafe.getJavaStringArray(javaString);
            int strideStr = TStringUnsafe.getJavaStringStride(javaString);
            int offsetStr = fromIndex << strideStr;
            if ((strideStr | sb.stride) == 0) {
                sb.updateCodeRange(TSCodeRange.markImprecise(TSCodeRange.get8Bit()));
                sb.ensureCapacityS0(this, lengthStr, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(this, arrayStr, offsetStr, 0, 0, sb.buf, 0, 0, sb.length, lengthStr);
                sb.codePointLength += lengthStr;
            } else {
                int codePointLength;
                int codeRange;
                slowPathProfile.enter(this);
                if (strideStr == 0) {
                    codeRange = TSCodeRange.markImprecise(TSCodeRange.get8Bit());
                    codePointLength = lengthStr;
                } else {
                    long attrs = TStringOps.calcStringAttributesUTF16(this, arrayStr, offsetStr, lengthStr, false);
                    codeRange = StringAttributes.getCodeRange(attrs);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                }
                sb.updateCodeRange(codeRange);
                sb.ensureCapacityAndInflate(this, lengthStr, Stride.fromCodeRangeUTF16AllowImprecise(codeRange), inflateProfile, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(this, arrayStr, offsetStr, strideStr, 0, sb.buf, 0, sb.stride, sb.length, lengthStr);
                sb.codePointLength += codePointLength;
            }
            sb.length += lengthStr;
        }

        @NeverDefault
        public static AppendJavaStringUTF16Node create() {
            return TruffleStringBuilderFactory.AppendJavaStringUTF16NodeGen.create();
        }

        public static AppendJavaStringUTF16Node getUncached() {
            return TruffleStringBuilderFactory.AppendJavaStringUTF16NodeGen.getUncached();
        }
    }

    public static abstract class ToStringNode
    extends AbstractPublicNode {
        ToStringNode() {
        }

        public final TruffleString execute(TruffleStringBuilder sb) {
            return this.execute(sb, false);
        }

        public abstract TruffleString execute(TruffleStringBuilder var1, boolean var2);

        @Specialization
        final TruffleString createString(TruffleStringBuilder sb, boolean lazy, @Cached ToStringIntlNode intlNode) {
            return intlNode.execute(this, sb, lazy);
        }

        @NeverDefault
        public static ToStringNode create() {
            return TruffleStringBuilderFactory.ToStringNodeGen.create();
        }

        public static ToStringNode getUncached() {
            return TruffleStringBuilderFactory.ToStringNodeGen.getUncached();
        }
    }

    static abstract class ToStringIntlNode
    extends AbstractInternalNode {
        ToStringIntlNode() {
        }

        public abstract TruffleString execute(Node var1, TruffleStringBuilder var2, boolean var3);

        @Specialization
        static TruffleString createString(Node node, TruffleStringBuilderUTF8 sb, boolean lazy, @Cached @Cached.Shared InlinedConditionProfile calcAttributesProfile, @Cached @Cached.Exclusive InlinedConditionProfile brokenProfile) {
            int codePointLength;
            int codeRange;
            if (sb.length == 0) {
                return TruffleString.Encoding.UTF_8.getEmpty();
            }
            if (calcAttributesProfile.profile(node, !TSCodeRange.isPrecise(sb.codeRange) || TSCodeRange.isBrokenMultiByte(sb.codeRange))) {
                long attrs = TStringOps.calcStringAttributesUTF8(node, sb.buf, 0, sb.length, false, true, brokenProfile);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                codeRange = sb.codeRange;
                codePointLength = sb.codePointLength;
            }
            byte[] bytes = lazy || sb.buf.length == sb.length ? sb.buf : Arrays.copyOf(sb.buf, sb.length);
            return TruffleString.createFromByteArray(bytes, sb.length, 0, TruffleString.Encoding.UTF_8, codePointLength, codeRange);
        }

        @Specialization
        static TruffleString createString(Node node, TruffleStringBuilderUTF16 sb, boolean lazy, @Cached @Cached.Shared InlinedConditionProfile calcAttributesProfile) {
            int codePointLength;
            int codeRange;
            if (sb.length == 0) {
                return TruffleString.Encoding.UTF_16.getEmpty();
            }
            if (calcAttributesProfile.profile(node, TSCodeRange.isBrokenMultiByte(sb.codeRange))) {
                assert (sb.stride == 1);
                long attrs = TStringOps.calcStringAttributesUTF16(node, sb.buf, 0, sb.length, false);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                codeRange = sb.codeRange;
                codePointLength = sb.codePointLength;
            }
            int byteLength = sb.length << sb.stride;
            byte[] bytes = lazy || sb.buf.length == byteLength ? sb.buf : Arrays.copyOf(sb.buf, byteLength);
            return TruffleString.createFromByteArray(bytes, sb.length, sb.stride, TruffleString.Encoding.UTF_16, codePointLength, codeRange);
        }

        @Specialization
        static TruffleString createString(TruffleStringBuilderUTF32 sb, boolean lazy) {
            if (sb.length == 0) {
                return TruffleString.Encoding.UTF_32.getEmpty();
            }
            int byteLength = sb.length << sb.stride;
            byte[] bytes = lazy || sb.buf.length == byteLength ? sb.buf : Arrays.copyOf(sb.buf, byteLength);
            return TruffleString.createFromByteArray(bytes, sb.length, sb.stride, TruffleString.Encoding.UTF_32, sb.length, sb.codeRange);
        }

        @Specialization
        static TruffleString createString(Node node, TruffleStringBuilderGeneric sb, boolean lazy, @Cached @Cached.Shared InlinedConditionProfile calcAttributesProfile, @Cached TStringInternalNodes.CalcStringAttributesNode calcAttributesNode) {
            int codePointLength;
            int codeRange;
            if (sb.length == 0) {
                return sb.encoding.getEmpty();
            }
            if (calcAttributesProfile.profile(node, !TSCodeRange.isPrecise(sb.codeRange) || TSCodeRange.isBrokenMultiByte(sb.codeRange))) {
                long attrs = calcAttributesNode.execute(node, null, sb.buf, 0, sb.length, 0, sb.encoding, 0, sb.codeRange);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else {
                codeRange = sb.codeRange;
                codePointLength = sb.codePointLength;
            }
            byte[] bytes = lazy || sb.buf.length == sb.length ? sb.buf : Arrays.copyOf(sb.buf, sb.length);
            return TruffleString.createFromByteArray(bytes, sb.length, 0, sb.encoding, codePointLength, codeRange);
        }
    }

    static abstract class AppendStringIntlNode
    extends AbstractInternalNode {
        AppendStringIntlNode() {
        }

        public abstract void execute(Node var1, TruffleStringBuilder var2, AbstractTruffleString var3);

        @Specialization
        static void append(Node node, TruffleStringBuilderUTF8 sb, AbstractTruffleString a, @Cached @Cached.Shared TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (a.length() == 0) {
                return;
            }
            a.checkEncoding(TruffleString.Encoding.UTF_8);
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            sb.updateCodeRange(a.codeRange());
            sb.ensureCapacityS0(node, a.length(), bufferGrowProfile, errorProfile);
            TStringOps.arraycopyWithStride(node, arrayA, a.offset(), 0, 0, sb.buf, 0, 0, sb.length, a.length());
            sb.codePointLength += a.codePointLength();
            sb.length += a.length();
        }

        @Specialization
        static void append(Node node, TruffleStringBuilderUTF16 sb, AbstractTruffleString a, @Cached @Cached.Shared TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Exclusive TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Exclusive TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Shared InlinedBranchProfile slowPathProfile, @Cached @Cached.Shared InlinedBranchProfile inflateProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (a.length() == 0) {
                return;
            }
            a.checkEncoding(TruffleString.Encoding.UTF_16);
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            if ((a.stride() | sb.stride) == 0) {
                sb.updateCodeRange(a.codeRange());
                sb.ensureCapacityS0(node, a.length(), bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(node, arrayA, a.offset(), 0, 0, sb.buf, 0, 0, sb.length, a.length());
                sb.codePointLength += a.length();
            } else {
                slowPathProfile.enter(node);
                int codeRangeA = getPreciseCodeRangeNode.execute(node, a, TruffleString.Encoding.UTF_16);
                sb.codePointLength += getCodePointLengthNode.execute(node, a, TruffleString.Encoding.UTF_16);
                sb.updateCodeRange(codeRangeA);
                sb.ensureCapacityAndInflate(node, a.length(), Stride.fromCodeRangeUTF16(codeRangeA), inflateProfile, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(node, arrayA, a.offset(), a.stride(), 0, sb.buf, 0, sb.stride, sb.length, a.length());
            }
            sb.length += a.length();
        }

        @Specialization
        static void append(Node node, TruffleStringBuilderUTF32 sb, AbstractTruffleString a, @Cached @Cached.Shared TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Exclusive TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared InlinedBranchProfile slowPathProfile, @Cached @Cached.Shared InlinedBranchProfile inflateProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (a.length() == 0) {
                return;
            }
            a.checkEncoding(TruffleString.Encoding.UTF_32);
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            if ((a.stride() | sb.stride) == 0) {
                sb.updateCodeRange(a.codeRange());
                sb.ensureCapacityS0(node, a.length(), bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(node, arrayA, a.offset(), 0, 0, sb.buf, 0, 0, sb.length, a.length());
            } else {
                slowPathProfile.enter(node);
                int codeRangeA = getPreciseCodeRangeNode.execute(node, a, TruffleString.Encoding.UTF_32);
                sb.updateCodeRange(codeRangeA);
                sb.ensureCapacityAndInflate(node, a.length(), Stride.fromCodeRangeUTF32(codeRangeA), inflateProfile, bufferGrowProfile, errorProfile);
                TStringOps.arraycopyWithStride(node, arrayA, a.offset(), a.stride(), 0, sb.buf, 0, sb.stride, sb.length, a.length());
            }
            sb.length += a.length();
        }

        @Specialization
        static void append(Node node, TruffleStringBuilderGeneric sb, AbstractTruffleString a, @Cached @Cached.Exclusive TruffleString.ToIndexableNode toIndexableNode, @Cached @Cached.Exclusive TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Exclusive TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Exclusive InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Exclusive InlinedBranchProfile errorProfile) {
            if (a.length() == 0) {
                return;
            }
            a.checkEncoding(sb.encoding);
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            int codeRangeA = getPreciseCodeRangeNode.execute(node, a, sb.encoding);
            sb.updateCodeRange(codeRangeA);
            sb.ensureCapacityS0(node, a.length(), bufferGrowProfile, errorProfile);
            TStringOps.arraycopyWithStride(node, arrayA, a.offset(), 0, 0, sb.buf, 0, 0, sb.length, a.length());
            sb.appendLength(a.length(), getCodePointLengthNode.execute(node, a, sb.encoding));
        }
    }

    static abstract class AppendCodePointIntlNode
    extends AbstractInternalNode {
        AppendCodePointIntlNode() {
        }

        abstract void execute(Node var1, TruffleStringBuilder var2, int var3, int var4, boolean var5);

        @Specialization
        static void append(Node node, TruffleStringBuilderUTF8 sb, int codepoint, int repeat, boolean allowUTF16Surrogates, @Cached @Cached.Shared InlinedBranchProfile multiByteProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (Integer.compareUnsigned(codepoint, 127) <= 0) {
                AppendCodePointIntlNode.appendAscii(node, sb, (byte)codepoint, repeat, bufferGrowProfile, errorProfile);
            } else {
                multiByteProfile.enter(node);
                if (Integer.compareUnsigned(codepoint, 0x10FFFF) > 0 || !allowUTF16Surrogates && Encodings.isUTF16Surrogate(codepoint)) {
                    throw InternalErrors.invalidCodePoint(codepoint);
                }
                sb.updateCodeRange(TSCodeRange.getValidMultiByte());
                int length = Encodings.utf8EncodedSize(codepoint);
                try {
                    sb.ensureCapacityS0(node, Math.multiplyExact(repeat, length), bufferGrowProfile, errorProfile);
                }
                catch (ArithmeticException e) {
                    errorProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                for (int i = 0; i < repeat; ++i) {
                    Encodings.utf8Encode(codepoint, sb.buf, sb.length, length);
                    sb.length += length;
                }
            }
            sb.codePointLength += repeat;
        }

        @Specialization
        static void append(Node node, TruffleStringBuilderUTF16 sb, int codepoint, int repeat, boolean allowUTF16Surrogates, @Cached @Cached.Shared InlinedBranchProfile nonAsciiProfile, @Cached @Cached.Shared InlinedBranchProfile multiByteProfile, @Cached @Cached.Shared InlinedBranchProfile inflateProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if ((sb.stride | codepoint >>> 7) == 0) {
                AppendCodePointIntlNode.appendAscii(node, sb, (byte)codepoint, repeat, bufferGrowProfile, errorProfile);
            } else if (Integer.compareUnsigned(codepoint, 255) <= 0) {
                if (codepoint > 127) {
                    sb.updateCodeRange(TSCodeRange.get8Bit());
                }
                sb.ensureCapacityWithStride(node, repeat, bufferGrowProfile, errorProfile);
                for (int i = 0; i < repeat; ++i) {
                    TStringOps.writeToByteArray(sb.buf, sb.stride, sb.length++, codepoint);
                }
            } else if (Integer.compareUnsigned(codepoint, 65535) <= 0) {
                int codeRangeA;
                nonAsciiProfile.enter(node);
                if (Encodings.isUTF16Surrogate(codepoint)) {
                    if (!allowUTF16Surrogates) {
                        throw InternalErrors.invalidCodePoint(codepoint);
                    }
                    codeRangeA = TSCodeRange.getBrokenMultiByte();
                } else {
                    codeRangeA = TSCodeRange.get16Bit();
                }
                sb.updateCodeRange(codeRangeA);
                sb.ensureCapacityAndInflate(node, repeat, 1, inflateProfile, bufferGrowProfile, errorProfile);
                assert (sb.stride == 1);
                for (int i = 0; i < repeat; ++i) {
                    TStringOps.writeToByteArray(sb.buf, 1, sb.length++, codepoint);
                }
            } else {
                if (Integer.compareUnsigned(codepoint, 0x10FFFF) > 0) {
                    throw InternalErrors.invalidCodePoint(codepoint);
                }
                multiByteProfile.enter(node);
                sb.updateCodeRange(TSCodeRange.getValidMultiByte());
                try {
                    sb.ensureCapacityAndInflate(node, Math.multiplyExact(repeat, 2), 1, inflateProfile, bufferGrowProfile, errorProfile);
                }
                catch (ArithmeticException e) {
                    errorProfile.enter(node);
                    throw InternalErrors.outOfMemory();
                }
                for (int i = 0; i < repeat; ++i) {
                    Encodings.utf16EncodeSurrogatePair(codepoint, sb.buf, sb.length);
                    sb.length += 2;
                }
            }
            sb.codePointLength += repeat;
        }

        @Specialization
        static void append(Node node, TruffleStringBuilderUTF32 sb, int codepoint, int repeat, boolean allowUTF16Surrogates, @Cached @Cached.Shared InlinedBranchProfile nonAsciiProfile, @Cached @Cached.Shared InlinedBranchProfile inflateProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if ((sb.stride | codepoint >>> 7) == 0) {
                AppendCodePointIntlNode.appendAscii(node, sb, (byte)codepoint, repeat, bufferGrowProfile, errorProfile);
            } else {
                int strideA;
                int codeRangeA;
                nonAsciiProfile.enter(node);
                if (Integer.compareUnsigned(codepoint, 127) <= 0) {
                    codeRangeA = TSCodeRange.get7Bit();
                    strideA = 0;
                } else if (Integer.compareUnsigned(codepoint, 255) <= 0) {
                    codeRangeA = TSCodeRange.get8Bit();
                    strideA = 0;
                } else if (Encodings.isUTF16Surrogate(codepoint)) {
                    if (!allowUTF16Surrogates) {
                        throw InternalErrors.invalidCodePoint(codepoint);
                    }
                    codeRangeA = TSCodeRange.getBrokenFixedWidth();
                    strideA = 2;
                } else if (Integer.compareUnsigned(codepoint, 65535) <= 0) {
                    codeRangeA = TSCodeRange.get16Bit();
                    strideA = 1;
                } else {
                    if (Integer.compareUnsigned(codepoint, 0x10FFFF) > 0) {
                        throw InternalErrors.invalidCodePoint(codepoint);
                    }
                    codeRangeA = TSCodeRange.getValidFixedWidth();
                    strideA = 2;
                }
                sb.updateCodeRange(codeRangeA);
                sb.ensureCapacityAndInflate(node, repeat, strideA, inflateProfile, bufferGrowProfile, errorProfile);
                for (int i = 0; i < repeat; ++i) {
                    TStringOps.writeToByteArray(sb.buf, sb.stride, sb.length++, codepoint);
                }
            }
        }

        @Specialization
        static void generic(Node node, TruffleStringBuilderGeneric sb, int codepoint, int repeat, boolean allowUTF16Surrogates, @Cached @Cached.Exclusive InlinedConditionProfile supportedProfile, @Cached @Cached.Shared InlinedBranchProfile bufferGrowProfile, @Cached @Cached.Shared InlinedBranchProfile errorProfile) {
            if (supportedProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(sb.encoding))) {
                if (codepoint > 255) {
                    throw InternalErrors.invalidCodePoint(codepoint);
                }
                sb.ensureCapacityWithStride(node, repeat, bufferGrowProfile, errorProfile);
                if (codepoint > 127) {
                    sb.updateCodeRange(TSCodeRange.asciiLatinBytesNonAsciiCodeRange(sb.encoding));
                }
                Arrays.fill(sb.buf, sb.length, sb.length + repeat, (byte)codepoint);
                sb.length += repeat;
            } else {
                assert (TStringGuards.isUnsupportedEncoding(sb.encoding));
                JCodings jcodings = JCodings.getInstance();
                if (Integer.compareUnsigned(codepoint, 0x10FFFF) > 0) {
                    throw InternalErrors.invalidCodePoint(codepoint);
                }
                int length = jcodings.getCodePointLength(sb.encoding, codepoint);
                if (!sb.encoding.is7BitCompatible() || codepoint > 127) {
                    sb.updateCodeRange(TSCodeRange.getValid(jcodings.isSingleByte(sb.encoding)));
                }
                if (length < 1) {
                    throw InternalErrors.invalidCodePoint(codepoint);
                }
                sb.ensureCapacityWithStride(node, length * repeat, bufferGrowProfile, errorProfile);
                for (int i = 0; i < repeat; ++i) {
                    int ret = jcodings.writeCodePoint(sb.encoding, codepoint, sb.buf, sb.length);
                    if (ret != length || jcodings.getCodePointLength(sb.encoding, sb.buf, sb.length, sb.length + length) != ret || jcodings.readCodePoint(sb.encoding, sb.buf, sb.length, sb.length + length, DecodingErrorHandler.RETURN_NEGATIVE) != codepoint) {
                        throw InternalErrors.invalidCodePoint(codepoint);
                    }
                    sb.length += length;
                }
            }
            sb.codePointLength += repeat;
        }

        private static void appendAscii(Node node, TruffleStringBuilder sb, byte codepoint, int repeat, InlinedBranchProfile bufferGrowProfile, InlinedBranchProfile errorProfile) {
            sb.ensureCapacityS0(node, repeat, bufferGrowProfile, errorProfile);
            for (int i = 0; i < repeat; ++i) {
                sb.buf[sb.length++] = codepoint;
            }
        }
    }
}

