/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyResponseHeaders;
import com.ning.http.client.providers.grizzly.PauseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.common.client.sse.ProgressiveBodyDataListener;
import org.mule.service.http.impl.service.client.HttpResponseCreator;
import org.mule.service.http.impl.service.client.NonBlockingStreamWriter;
import org.mule.service.http.impl.service.util.ThreadContext;
import org.mule.service.http.impl.util.TimedPipedInputStream;
import org.mule.service.http.impl.util.TimedPipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ResponseBodyDeferringAsyncHandler
implements AsyncHandler<Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseBodyDeferringAsyncHandler.class);
    private static final String PIPE_READ_TIMEOUT_PROPERTY_NAME = "mule.http.responseStreaming.pipeReadTimeoutMillis";
    private static long PIPE_READ_TIMEOUT_MILLIS = Integer.parseInt(System.getProperty("mule.http.responseStreaming.pipeReadTimeoutMillis", "20000"));
    private static Field responseField;
    private volatile Response response;
    private int bufferSize;
    private final NonBlockingStreamWriter nonBlockingStreamWriter;
    private final ProgressiveBodyDataListener dataListener;
    private final ExecutorService workerScheduler;
    private TimedPipedOutputStream output;
    private Optional<TimedPipedInputStream> input = Optional.empty();
    private final CompletableFuture<HttpResponse> future;
    private final Response.ResponseBuilder responseBuilder = new Response.ResponseBuilder();
    private final HttpResponseCreator httpResponseCreator = new HttpResponseCreator();
    private final AtomicBoolean handled = new AtomicBoolean(false);
    private final Map<String, String> mdc;
    private final AtomicBoolean throwableReceived = new AtomicBoolean(false);
    private final AtomicBoolean lastPartReceived = new AtomicBoolean(false);

    public ResponseBodyDeferringAsyncHandler(CompletableFuture<HttpResponse> future, int userDefinedBufferSize, ExecutorService workerScheduler, NonBlockingStreamWriter nonBlockingStreamWriter, ProgressiveBodyDataListener dataListener) {
        this.future = future;
        this.bufferSize = userDefinedBufferSize;
        this.workerScheduler = workerScheduler;
        this.nonBlockingStreamWriter = nonBlockingStreamWriter;
        this.dataListener = dataListener;
        this.mdc = MDC.getCopyOfContextMap();
    }

    public void onThrowable(Throwable t) {
        this.throwableReceived.set(true);
        try {
            MDC.setContextMap(this.mdc);
            LOGGER.debug("Error caught handling response body", t);
            try {
                this.closeOut();
            }
            catch (IOException e) {
                LOGGER.debug("Error closing HTTP response stream", (Throwable)e);
            }
            if (!this.handled.getAndSet(true)) {
                Exception exception = t instanceof TimeoutException ? (TimeoutException)t : (t instanceof IOException ? (IOException)t : new IOException(t.getMessage(), t));
                this.future.completeExceptionally(exception);
            } else {
                if (t.getMessage() != null && t.getMessage().contains("Pipe closed")) {
                    LOGGER.error("HTTP response stream was closed before being read but response streams must always be consumed. Set log level to DEBUG for details.");
                } else {
                    LOGGER.warn("Error handling HTTP response stream. Set log level to DEBUG for details.");
                }
                LOGGER.debug("HTTP response stream error was ", t);
            }
        }
        finally {
            MDC.clear();
        }
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        try {
            MDC.setContextMap(this.mdc);
            if (this.errorDetected()) {
                AsyncHandler.STATE sTATE = this.closeAndAbort();
                return sTATE;
            }
            this.responseBuilder.reset();
            this.responseBuilder.accumulate(responseStatus);
            AsyncHandler.STATE sTATE = AsyncHandler.STATE.CONTINUE;
            return sTATE;
        }
        finally {
            MDC.clear();
        }
    }

    private AsyncHandler.STATE closeAndAbort() throws IOException {
        this.closeOut();
        return AsyncHandler.STATE.ABORT;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        try {
            MDC.setContextMap(this.mdc);
            if (this.errorDetected()) {
                AsyncHandler.STATE sTATE = this.closeAndAbort();
                return sTATE;
            }
            this.responseBuilder.accumulate(headers);
            if (this.bufferSize < 0) {
                LOGGER.debug("onHeadersReceived. No configured buffer size, resolving buffer size dynamically.");
                this.calculateBufferSize(headers);
            } else {
                LOGGER.debug("onHeadersReceived. Using user configured buffer size of '{} bytes'.", (Object)this.bufferSize);
            }
            AsyncHandler.STATE sTATE = AsyncHandler.STATE.CONTINUE;
            return sTATE;
        }
        finally {
            MDC.clear();
        }
    }

    private void calculateBufferSize(HttpResponseHeaders headers) {
        int maxBufferSize = TCPNIOTransport.MAX_RECEIVE_BUFFER_SIZE;
        String contentLength = headers.getHeaders().getFirstValue("Content-Length");
        if (!StringUtils.isEmpty((CharSequence)contentLength) && StringUtils.isEmpty((CharSequence)headers.getHeaders().getFirstValue("Transfer-Encoding"))) {
            long contentLengthLong = Long.parseLong(contentLength);
            try {
                if (responseField != null && headers instanceof GrizzlyResponseHeaders) {
                    maxBufferSize = ((HttpResponsePacket)responseField.get(headers)).getRequest().getConnection().getReadBufferSize();
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.debug("Unable to access connection buffer size.");
            }
            this.bufferSize = (int)Math.min((long)maxBufferSize, contentLengthLong);
        } else {
            this.bufferSize = DataUnit.KB.toBytes(32) + 10;
        }
        LOGGER.debug("Max buffer size = {} bytes, Connection buffer size = {} bytes, Content-length = {} bytes, Calculated buffer size = {} bytes", new Object[]{TCPNIOTransport.MAX_RECEIVE_BUFFER_SIZE, maxBufferSize, contentLength, this.bufferSize});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        try {
            MDC.setContextMap(this.mdc);
            if (bodyPart.isLast()) {
                this.lastPartReceived.set(true);
            }
            if (this.errorDetected()) {
                AsyncHandler.STATE sTATE = this.closeAndAbort();
                return sTATE;
            }
            if (!this.input.isPresent()) {
                if (bodyPart.isLast()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Single part (size = {} bytes).", (Object)bodyPart.getBodyByteBuffer().remaining());
                    }
                    this.responseBuilder.accumulate(bodyPart);
                    this.handleIfNecessary();
                    this.dataListener.onDataAvailable(bodyPart.length());
                    this.dataListener.onEndOfStream();
                    AsyncHandler.STATE sTATE = AsyncHandler.STATE.CONTINUE;
                    return sTATE;
                }
                this.output = new TimedPipedOutputStream();
                this.input = Optional.of(new TimedPipedInputStream(this.bufferSize, PIPE_READ_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS, this.output, () -> {
                    if (null != this.nonBlockingStreamWriter) {
                        this.nonBlockingStreamWriter.notifyAvailableSpace();
                    }
                }));
            }
            this.handleIfNecessary();
            if (this.errorDetected()) {
                AsyncHandler.STATE sTATE = this.closeAndAbort();
                return sTATE;
            }
            AsyncHandler.STATE sTATE = this.writeBodyPartToPipe(bodyPart);
            return sTATE;
        }
        finally {
            MDC.clear();
        }
    }

    private AsyncHandler.STATE writeBodyPartToPipe(HttpResponseBodyPart bodyPart) throws IOException {
        int bodyLength = bodyPart.length();
        int spaceInPipe = this.availableSpaceInPipe();
        if (this.nonBlockingStreamWriter.isEnabled() && spaceInPipe >= 0 && spaceInPipe < bodyLength) {
            PauseHandler pauseHandler = bodyPart.getPauseHandler();
            pauseHandler.requestPause();
            this.nonBlockingStreamWriter.addDataToWrite(this.output, bodyPart.getBodyPartBytes(), this::availableSpaceInPipe).whenComplete((BiConsumer)this.resumeCallback(pauseHandler, bodyPart));
        } else {
            bodyPart.writeTo((OutputStream)this.output);
            this.dataListener.onDataAvailable(bodyLength);
            if (bodyPart.isLast()) {
                this.closeOut();
                this.dataListener.onEndOfStream();
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    private BiConsumer<Void, Throwable> resumeCallback(PauseHandler pauseHandler, HttpResponseBodyPart bodyPart) {
        return (ignored, error) -> {
            if (error != null) {
                this.onThrowable((Throwable)error);
            }
            try {
                this.dataListener.onDataAvailable(bodyPart.length());
                if (bodyPart.isLast()) {
                    this.closeOut();
                    this.dataListener.onEndOfStream();
                }
                pauseHandler.resume();
            }
            catch (Exception e) {
                this.onThrowable(e);
            }
        };
    }

    private int availableSpaceInPipe() {
        if (!this.input.isPresent()) {
            return -1;
        }
        if (this.input.get().isClosed()) {
            return -1;
        }
        return this.bufferSize - this.input.get().available();
    }

    private boolean errorDetected() {
        return this.future.isCompletedExceptionally() || this.throwableReceived.get();
    }

    protected void closeOut() throws IOException {
        if (this.output != null) {
            try {
                this.output.flush();
            }
            finally {
                this.output.close();
            }
        }
    }

    public Response onCompleted() throws IOException {
        try {
            MDC.setContextMap(this.mdc);
            LOGGER.debug("Completed response");
            this.handleIfNecessary();
            if (!this.lastPartReceived.get()) {
                this.closeOut();
                this.dataListener.onEndOfStream();
            }
            Response response = null;
            return response;
        }
        finally {
            MDC.clear();
        }
    }

    private void handleIfNecessary() {
        if (!this.handled.getAndSet(true)) {
            if (this.shouldCompleteAsync()) {
                try {
                    LOGGER.debug("Scheduling response future completion to workers scheduler");
                    ClassLoader outerTccl = Thread.currentThread().getContextClassLoader();
                    this.workerScheduler.submit(() -> {
                        try (ThreadContext ctx = new ThreadContext(outerTccl, this.mdc);){
                            this.completeResponseFuture();
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    LOGGER.warn("Couldn't schedule completion to workers scheduler, completing it synchronously");
                    this.completeResponseFuture();
                }
            } else {
                this.completeResponseFuture();
            }
        }
    }

    private boolean shouldCompleteAsync() {
        return this.input.isPresent();
    }

    private void completeResponseFuture() {
        this.response = this.responseBuilder.build();
        try {
            InputStream is = this.createResponseInputStream();
            this.dataListener.onStreamCreated(is);
            this.future.complete(this.httpResponseCreator.create(this.response, is));
        }
        catch (IOException e) {
            this.onThrowable(e);
            this.future.completeExceptionally(e);
        }
    }

    private InputStream createResponseInputStream() throws IOException {
        if (this.input.isPresent()) {
            return this.input.get();
        }
        return this.response.getResponseBodyAsStream();
    }

    @Deprecated
    static void refreshSystemProperties() {
        PIPE_READ_TIMEOUT_MILLIS = Integer.parseInt(System.getProperty(PIPE_READ_TIMEOUT_PROPERTY_NAME, "20000"));
    }

    static {
        try {
            responseField = GrizzlyResponseHeaders.class.getDeclaredField("response");
            responseField.setAccessible(true);
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to use reflection to access connection buffer size to optimize streaming.", e);
        }
    }
}

