/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.client.sse;

import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.service.http.common.message.sse.SseEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSentEventDecoder
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerSentEventDecoder.class);
    private static final String LINE_BREAK_REGEX = "\\R";
    private final SseEventBuilder eventBuilder = new SseEventBuilder();
    private final SseListener eventListener;
    private static final AtomicLong idGenerator = new AtomicLong();
    private String notParsedData = "";
    private final Long id;

    public ServerSentEventDecoder(SseListener eventListener) {
        this.eventListener = eventListener;
        this.id = idGenerator.incrementAndGet();
    }

    public void decode(byte[] data, int actualRead) {
        this.notParsedData = this.notParsedData + new String(data, 0, actualRead);
        String[] lines = this.notParsedData.split(LINE_BREAK_REGEX, -1);
        int linesNumber = lines.length;
        for (int i = 0; i < linesNumber - 1; ++i) {
            LOGGER.trace("SSE Decoder ({}): Handling line: {}", (Object)this.id, (Object)lines[i]);
            this.handleLine(lines[i]);
        }
        this.notParsedData = lines[linesNumber - 1];
        LOGGER.trace("SSE Decoder ({}): Found data after last line separator: {}", (Object)this.id, (Object)this.notParsedData);
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public void close() {
        this.eventListener.onClose();
    }

    private void handleLine(String line) {
        if (null == line || line.isEmpty()) {
            ServerSentEvent serverSentEvent = this.eventBuilder.buildAndClear();
            LOGGER.debug("SSE Decoder ({}): Reading server-sent event: {}", (Object)this.id, (Object)serverSentEvent);
            this.eventListener.onEvent(serverSentEvent);
        } else if (line.startsWith("data:")) {
            this.eventBuilder.withData(line.substring(5).trim());
        } else if (line.startsWith("event:")) {
            this.eventBuilder.withName(line.substring(6).trim());
        } else if (line.startsWith("id:")) {
            this.eventBuilder.withId(line.substring(3).trim());
        } else if (line.startsWith("retry:")) {
            this.eventBuilder.withRetryDelay(this.parseRetryDelay(line.substring(6).trim()));
        }
    }

    private Long parseRetryDelay(String asString) {
        try {
            return Long.parseLong(asString);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("SSE Decoder ({}): Failed to parse retry delay because '{}' is not a number", new Object[]{this.id, asString, e});
            return null;
        }
    }
}

