/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.utils.server;

import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.rules.ExternalResource;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.SslContextHelper;

public class TestHttpServer
extends ExternalResource {
    private final ExecutorService ioExecutor = Executors.newCachedThreadPool();
    private static final String PASS = "mulepassword";
    private final String host;
    private final int port;
    private final boolean useSsl;
    private final HttpListenerRegistry httpListenerRegistry;
    private HttpServer httpServer;

    public TestHttpServer(String host, int port, boolean useSsl) {
        this.host = host;
        this.port = port;
        this.useSsl = useSsl;
        this.httpListenerRegistry = new HttpListenerRegistry();
    }

    protected void before() throws Throwable {
        SslContext sslContext = this.createSslContext();
        this.httpServer = NettyHttpServer.builder().withSslContext(sslContext).withShutdownTimeout(() -> 5000L).withServerAddress(new InetSocketAddress(this.host, this.port)).withHttpListenerRegistry(this.httpListenerRegistry).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.httpListenerRegistry, true, 30000, 10000L, sslContext, this.ioExecutor)).build();
        this.httpServer.start();
    }

    protected void after() {
        this.httpServer.stop().dispose();
        this.ioExecutor.shutdownNow();
    }

    public SslContext createSslContext() throws NoSuchAlgorithmException, KeyManagementException, CreateException {
        if (!this.useSsl) {
            return null;
        }
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().keyStorePath("serverKeystore").keyStorePassword(PASS).keyPassword(PASS).build();
        return SslContextHelper.sslContextForServer((TlsContextFactory)tlsContextFactory);
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.httpListenerRegistry.addRequestHandler(this.httpServer, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }

    public void removeAllHandlers() {
        this.httpListenerRegistry.removeHandlersFor(this.httpServer);
    }
}

