/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.mule.runtime.ast.internal.serialization.dto.ParserAttributesDTO;

public class ParserAttributesJsonTypeAdapter
implements JsonSerializer<ParserAttributesDTO>,
JsonDeserializer<ParserAttributesDTO> {
    public ParserAttributesDTO deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!jsonElement.isJsonObject()) {
            throw new JsonParseException("Expected JSON object, but got: " + jsonElement);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        HashMap<String, Object> parserAttributes = new HashMap<String, Object>();
        jsonObject.entrySet().forEach(entry -> parserAttributes.put((String)entry.getKey(), this.fromTypedJsonElement((JsonElement)entry.getValue(), jsonDeserializationContext)));
        return new ParserAttributesDTO(parserAttributes);
    }

    public JsonElement serialize(ParserAttributesDTO parserAttributesDTO, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        parserAttributesDTO.get().forEach((key, value) -> jsonObject.add(key, this.toTypedJsonElement(value, jsonSerializationContext)));
        return jsonObject;
    }

    private JsonElement toTypedJsonElement(Object value, JsonSerializationContext jsonSerializationContext) {
        JsonObject attributeJsonObject = new JsonObject();
        attributeJsonObject.addProperty("type", value.getClass().getName());
        attributeJsonObject.add("value", jsonSerializationContext.serialize(value, value.getClass()));
        return attributeJsonObject;
    }

    private Object fromTypedJsonElement(JsonElement attributeElement, JsonDeserializationContext jsonDeserializationContext) {
        Class<?> attributeType;
        if (!attributeElement.isJsonObject()) {
            throw new JsonParseException("Expected JSON object, but got: " + attributeElement);
        }
        JsonObject attributeObject = attributeElement.getAsJsonObject();
        try {
            attributeType = this.getClass().getClassLoader().loadClass(attributeObject.get("type").getAsString());
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException("Type not found" + attributeElement, (Throwable)e);
        }
        return jsonDeserializationContext.deserialize(attributeObject.get("value"), attributeType);
    }
}

