/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.event.EventInternalContextResolver;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class UntilSuccessfulRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(UntilSuccessfulRouter.class);
    static final String RETRY_CTX_INTERNAL_PARAM_KEY = "untilSuccessful.router.retryContext";
    private static final String UNTIL_SUCCESSFUL_MSG = "'until-successful' retries exhausted";
    private final EventInternalContextResolver<Map<String, RetryContext>> retryContextResolver;
    private final Component owner;
    private final boolean suppressErrors;
    private final Predicate<CoreEvent> shouldRetry;
    private final ConditionalExecutorServiceDecorator delayScheduler;
    private final Flux<CoreEvent> upstreamFlux;
    private final Flux<CoreEvent> innerFlux;
    private final Flux<CoreEvent> downstreamFlux;
    private final FluxSinkRecorder<CoreEvent> innerRecorder = new FluxSinkRecorder();
    private final FluxSinkRecorder<Either<Throwable, CoreEvent>> downstreamRecorder = new FluxSinkRecorder();
    private final AtomicReference<ContextView> downstreamCtxReference = new AtomicReference<Context>(Context.empty());
    private Function<ExpressionManagerSession, Integer> maxRetriesSupplier;
    private Function<ExpressionManagerSession, Integer> delaySupplier;
    private Function<CoreEvent, ExpressionManagerSession> sessionSupplier;
    private final AtomicInteger inflightEvents = new AtomicInteger(0);
    private final AtomicBoolean completeDeferred = new AtomicBoolean(false);

    UntilSuccessfulRouter(Component owner, Publisher<CoreEvent> publisher, Processor nestedChain, ProcessingStrategy processingStrategy, ExtendedExpressionManager expressionManager, Predicate<CoreEvent> shouldRetry, Scheduler delayScheduler, String maxRetries, String millisBetweenRetries, boolean suppressErrors) {
        this.owner = owner;
        this.suppressErrors = suppressErrors;
        this.shouldRetry = shouldRetry;
        this.delayScheduler = new ConditionalExecutorServiceDecorator((ScheduledExecutorService)delayScheduler, s -> TransactionCoordination.isTransactionActive());
        this.retryContextResolver = new EventInternalContextResolver(RETRY_CTX_INTERNAL_PARAM_KEY, HashMap::new);
        this.upstreamFlux = Flux.from(publisher).doOnNext(event -> {
            RetryContext ctx = new RetryContext((CoreEvent)event, this.sessionSupplier, this.maxRetriesSupplier, this.delaySupplier);
            this.inflightEvents.getAndIncrement();
            this.innerRecorder.next((Object)this.eventWithCurrentContext((CoreEvent)event, ctx));
        }).doOnComplete(() -> {
            if (this.inflightEvents.get() == 0) {
                this.completeRouter();
            } else {
                this.completeDeferred.set(true);
            }
        });
        this.innerFlux = Flux.from((Publisher)processingStrategy.configureInternalPublisher((Publisher)this.innerRecorder.flux())).transform(innerPublisher -> MessageProcessors.applyWithChildContext((Publisher)innerPublisher, (ReactiveProcessor)nestedChain, Optional.of(owner.getLocation()))).doOnNext(successfulEvent -> {
            this.downstreamRecorder.next((Object)Either.right(Throwable.class, (Object)this.eventWithCurrentContextDeleted((CoreEvent)successfulEvent)));
            this.completeRouterIfNecessary();
        }).onErrorContinue(this.getRetryPredicate(), this.getRetryHandler());
        this.downstreamFlux = Flux.create(sink -> {
            this.downstreamRecorder.accept(sink);
            this.subscribeUpstreamChains(this.downstreamCtxReference.get());
        }).doOnNext(event -> this.inflightEvents.decrementAndGet()).map(this.getScopeResultMapper());
        this.maxRetriesSupplier = expressionManager.isExpression(maxRetries) ? this.expressionToIntegerSupplierFor(maxRetries) : session -> Integer.parseInt(maxRetries);
        this.delaySupplier = expressionManager.isExpression(millisBetweenRetries) ? this.expressionToIntegerSupplierFor(millisBetweenRetries) : session -> Integer.parseInt(millisBetweenRetries);
        this.sessionSupplier = !expressionManager.isExpression(maxRetries) && !expressionManager.isExpression(millisBetweenRetries) ? event -> null : event -> expressionManager.openSession(owner.getLocation(), event, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    private Function<Either<Throwable, CoreEvent>, CoreEvent> getScopeResultMapper() {
        return either -> {
            if (either.isLeft()) {
                throw Exceptions.propagate((Throwable)((Throwable)either.getLeft()));
            }
            return (CoreEvent)either.getRight();
        };
    }

    private BiConsumer<Throwable, Object> getRetryHandler() {
        return (error, offendingEvent) -> {
            MessagingException messagingError = (MessagingException)((Object)error);
            RetryContext ctx = this.getRetryContextForEvent(messagingError.getEvent());
            int retriesLeft = 0;
            if (ctx != null) {
                retriesLeft = ctx.retryCount.getAndDecrement();
            } else {
                LOGGER.error("The RetryContext was not found. This is probably a race condition. No further attempts for the until successful will be done.");
            }
            if (retriesLeft > 0) {
                LOGGER.error("Retrying execution of event, attempt {} of {}.", (Object)ctx.getAttemptNumber(), ctx.maxRetries != -1 ? ctx.maxRetries : "unlimited");
                this.delayScheduler.schedule(() -> this.innerRecorder.next((Object)this.eventWithCurrentContext(ctx.event, ctx)), (long)ctx.delayInMillis.intValue(), TimeUnit.MILLISECONDS);
            } else {
                LOGGER.error("Retry attempts exhausted. Failing...");
                Throwable resolvedError = ctx != null ? this.getThrowableFunction(ctx.event).apply((Throwable)error) : this.getThrowableFunction(messagingError.getEvent()).apply((Throwable)error);
                this.eventWithCurrentContextDeleted(messagingError.getEvent());
                this.downstreamRecorder.next((Object)Either.left((Object)resolvedError, CoreEvent.class));
                this.completeRouterIfNecessary();
            }
        };
    }

    private void completeRouterIfNecessary() {
        if (this.completeDeferred.get() && this.inflightEvents.get() == 0) {
            this.completeRouter();
        }
    }

    private void completeRouter() {
        this.innerRecorder.complete();
        this.downstreamRecorder.complete();
    }

    Publisher<CoreEvent> getDownstreamPublisher() {
        return this.downstreamFlux.transformDeferredContextual((downstreamPublisher, downstreamContext) -> downstreamPublisher.doOnSubscribe(s -> this.downstreamCtxReference.set((ContextView)downstreamContext)));
    }

    private void subscribeUpstreamChains(ContextView downstreamContext) {
        AtomicReference handledError = new AtomicReference();
        this.innerFlux.contextWrite(downstreamContext).subscribe(e -> {}, handledError::set);
        if (handledError.get() != null) {
            throw org.mule.runtime.core.api.rx.Exceptions.propagateWrappingFatal((Throwable)((Throwable)handledError.get()));
        }
        this.upstreamFlux.contextWrite(downstreamContext).subscribe(e -> {}, handledError::set);
        if (handledError.get() != null) {
            throw org.mule.runtime.core.api.rx.Exceptions.propagateWrappingFatal((Throwable)((Throwable)handledError.get()));
        }
    }

    private RetryContext getRetryContextForEvent(CoreEvent event) {
        return (RetryContext)((Map)this.retryContextResolver.getCurrentContextFromEvent(event)).get(event.getContext().getId());
    }

    private CoreEvent eventWithCurrentContext(CoreEvent event, RetryContext ctx) {
        Map retryCtxContainer = SmallMap.copy((Map)((Map)this.retryContextResolver.getCurrentContextFromEvent(event)));
        retryCtxContainer.put(event.getContext().getId(), ctx);
        return this.retryContextResolver.eventWithContext(event, (Object)retryCtxContainer);
    }

    private CoreEvent eventWithCurrentContextDeleted(CoreEvent event) {
        Map retryCtxContainer = (Map)this.retryContextResolver.getCurrentContextFromEvent(event);
        retryCtxContainer.remove(event.getContext().getId());
        return this.retryContextResolver.eventWithContext(event, (Object)retryCtxContainer);
    }

    private Predicate<Throwable> getRetryPredicate() {
        return e -> e instanceof MessagingException && this.shouldRetry.test(((MessagingException)((Object)e)).getEvent());
    }

    private Function<Throwable, Throwable> getThrowableFunction(CoreEvent event) {
        return throwable -> {
            CoreEvent exceptionEvent = event;
            Throwable retryPolicyExhaustionCause = this.suppressMuleException((Throwable)throwable);
            RetryPolicyExhaustedException retryPolicyExhaustedException = new RetryPolicyExhaustedException(I18nMessageFactory.createStaticMessage((String)UNTIL_SUCCESSFUL_MSG), retryPolicyExhaustionCause, (Object)this.owner);
            if (throwable instanceof MessagingException) {
                exceptionEvent = ((MessagingException)((Object)throwable)).getEvent();
            }
            return new MessagingException(exceptionEvent, (Throwable)retryPolicyExhaustedException, this.owner);
        };
    }

    private Throwable suppressMuleException(Throwable throwable) {
        if (this.suppressErrors) {
            return ExceptionHelper.suppressIfPresent((Throwable)throwable, MuleException.class);
        }
        return throwable;
    }

    private Function<ExpressionManagerSession, Integer> expressionToIntegerSupplierFor(String anExpression) {
        return session -> {
            try {
                return (Integer)session.evaluate(anExpression, DataType.NUMBER).getValue();
            }
            catch (Exception evaluationException) {
                throw new RetryContextInitializationException(evaluationException);
            }
        };
    }

    private static class RetryContext {
        CoreEvent event;
        AtomicInteger retryCount = new AtomicInteger();
        Integer delayInMillis;
        Integer maxRetries;

        RetryContext(CoreEvent event, Function<CoreEvent, ExpressionManagerSession> sessionSupplier, Function<ExpressionManagerSession, Integer> maxRetriesSupplier, Function<ExpressionManagerSession, Integer> delayTimeSupplier) {
            this.event = event;
            ExpressionManagerSession session = sessionSupplier.apply(event);
            this.maxRetries = maxRetriesSupplier.apply(session);
            this.delayInMillis = delayTimeSupplier.apply(session);
            this.retryCount.set(this.maxRetries);
        }

        int getAttemptNumber() {
            return this.maxRetries - this.retryCount.get();
        }
    }

    static class RetryContextInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = -399718600886069735L;

        public RetryContextInitializationException(Throwable cause) {
            super(cause);
        }
    }
}

