/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.function.Predicate;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphProvider;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.config.internal.validation.AbstractReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.FlowRefPointsToExistingFlow;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;

public class ReferenceParametersStereotypesValidations
extends AbstractReferenceParametersStereotypesValidations {
    public ReferenceParametersStereotypesValidations(ArtifactAstDependencyGraphProvider artifactAstDependencyGraphProvider) {
        super(artifactAstDependencyGraphProvider);
    }

    public String getName() {
        return "Reference parameters stereotypes";
    }

    public String getDescription() {
        return "Reference parameters point to declarations of the appropriate stereotype.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    protected Predicate<? super ComponentAstDependency> filterArtifact(ArtifactAst artifact) {
        return missing -> !missing.getComponent().getIdentifier().equals(FlowRefPointsToExistingFlow.FLOW_REF_IDENTIFIER) && missing.getAllowedStereotypes().stream().noneMatch(st -> st.isAssignableTo(MuleStereotypes.CONFIG) || st.isAssignableTo(MuleStereotypes.APP_CONFIG));
    }
}

