/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.provider;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.netty.impl.provider.NettyHttpServiceProvider;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class NettyHttpServiceProviderTestCase
extends AbstractMuleTestCase {
    private NettyHttpServiceProvider httpServiceProvider;

    @Before
    public void setup() {
        SchedulerService schedulerService = (SchedulerService)Mockito.mock(SchedulerService.class);
        this.httpServiceProvider = new NettyHttpServiceProvider();
        this.httpServiceProvider.setSchedulerService(schedulerService);
    }

    @Test
    public void providerCreatesDefinitionWithCorrectClass() {
        ServiceDefinition serviceDefinition = this.httpServiceProvider.getServiceDefinition();
        MatcherAssert.assertThat((Object)serviceDefinition.getServiceClass(), (Matcher)Matchers.is(HttpService.class));
    }

    @Test
    public void createdDefinitionReturnsCorrectServiceImplementation() {
        ServiceDefinition serviceDefinition = this.httpServiceProvider.getServiceDefinition();
        MatcherAssert.assertThat((Object)serviceDefinition.getService(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(NettyHttpServiceImplementation.class)));
        MatcherAssert.assertThat((Object)serviceDefinition.getService().getName(), (Matcher)Matchers.is((Object)"HTTP Service using Netty"));
    }
}

