/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.netty.impl.server.util.HttpParser;

public class StreamedMultipartHttpEntity
implements HttpEntity {
    private InputStream content;
    private String contentType;
    private Long contentLength;

    public StreamedMultipartHttpEntity(InputStream content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    public StreamedMultipartHttpEntity(InputStream content, String contentType, Long contentLength) {
        this(content, contentType);
        this.contentLength = contentLength;
    }

    public boolean isStreaming() {
        return true;
    }

    public boolean isComposed() {
        return true;
    }

    public InputStream getContent() throws UnsupportedOperationException {
        return this.content;
    }

    public byte[] getBytes() throws UnsupportedOperationException {
        return IOUtils.toByteArray((InputStream)this.content);
    }

    public Collection<HttpPart> getParts() throws IOException, UnsupportedOperationException {
        return HttpParser.parseMultipartContent(this.content, this.contentType);
    }

    public Optional<Long> getLength() {
        return Optional.ofNullable(this.contentLength);
    }
}

