/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import java.util.Map;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.MDC;

public class ThreadContext
implements AutoCloseable {
    private final Thread currentThread = Thread.currentThread();
    private final ClassLoader innerClassLoader;
    private final Map<String, String> innerMDC;
    private final ClassLoader outerClassLoader;
    private final Map<String, String> outerMDC;

    public ThreadContext(ClassLoader classLoader, Map<String, String> mdc) {
        this.innerClassLoader = classLoader;
        this.innerMDC = mdc;
        this.outerClassLoader = this.currentThread.getContextClassLoader();
        this.outerMDC = MDC.getCopyOfContextMap();
        if (this.innerMDC != null) {
            MDC.setContextMap(this.innerMDC);
        }
        ClassUtils.setContextClassLoader((Thread)this.currentThread, (ClassLoader)this.outerClassLoader, (ClassLoader)this.innerClassLoader);
    }

    @Override
    public void close() {
        try {
            ClassUtils.setContextClassLoader((Thread)this.currentThread, (ClassLoader)this.innerClassLoader, (ClassLoader)this.outerClassLoader);
        }
        finally {
            if (this.innerMDC != null) {
                MDC.setContextMap(this.outerMDC);
            }
        }
    }
}

