/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.api.component;

import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.dsl.api.component.TypeConverter;

public class CommonTypeConverters {
    public static TypeConverter<String, Class> stringToClassConverter() {
        return className -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static TypeConverter<String, Enum> stringToEnumConverter(Class<? extends Enum> enumType) {
        Preconditions.checkArgument((enumType != null ? 1 : 0) != 0, (String)"enumType cannot be null");
        return enumAsString -> {
            Preconditions.checkArgument((enumAsString != null ? 1 : 0) != 0, (String)"enumAsString cannot be null");
            return Enum.valueOf(enumType, enumAsString);
        };
    }

    private CommonTypeConverters() {
    }
}

