/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.impl.service.server.DefaultServerAddress;
import org.mule.service.http.impl.service.server.RequestHandlerProvider;
import org.mule.service.http.impl.service.server.grizzly.DefaultClientConnection;
import org.mule.service.http.impl.service.server.grizzly.DefaultHttpRequestContext;
import org.mule.service.http.impl.service.server.grizzly.DefaultServerConnection;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpRequestAdapter;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyHttpResponseReadyCallback;

public class GrizzlyRequestDispatcherFilter
extends BaseFilter {
    private final RequestHandlerProvider requestHandlerProvider;
    private final byte[] SERVER_NOT_AVAILABLE_CONTENT = "Server not available to handle this request, either not initialized yet or it has been disposed.".getBytes(Charset.defaultCharset());
    private ConcurrentMap<ServerAddress, AtomicInteger> activeRequests = new ConcurrentHashMap<ServerAddress, AtomicInteger>();

    GrizzlyRequestDispatcherFilter(RequestHandlerProvider requestHandlerProvider) {
        this.requestHandlerProvider = requestHandlerProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        InetSocketAddress localAddress = (InetSocketAddress)ctx.getConnection().getLocalAddress();
        DefaultServerAddress serverAddress = new DefaultServerAddress(localAddress.getAddress(), localAddress.getPort());
        AtomicInteger serverCounter = this.activeRequests.computeIfAbsent(serverAddress, sa -> new AtomicInteger());
        serverCounter.incrementAndGet();
        try {
            if (ctx.getMessage() instanceof HttpContent) {
                HttpContent httpContent = (HttpContent)ctx.getMessage();
                HttpRequestPacket request = (HttpRequestPacket)httpContent.getHttpHeader();
                if (!this.requestHandlerProvider.hasHandlerFor(serverAddress)) {
                    HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)request);
                    responsePacketBuilder.status(HttpStatus.SERVICE_UNAVAILABLE_503.getStatusCode());
                    responsePacketBuilder.reasonPhrase(HttpStatus.SERVICE_UNAVAILABLE_503.getReasonPhrase());
                    responsePacketBuilder.header("Content-Type", MediaType.TEXT.withCharset(Charset.defaultCharset()).toRfcString());
                    responsePacketBuilder.header("Content-Length", String.valueOf(this.SERVER_NOT_AVAILABLE_CONTENT.length));
                    ctx.write((Object)HttpContent.builder((HttpHeader)responsePacketBuilder.build()).content(Buffers.wrap((MemoryManager)ctx.getMemoryManager(), (byte[])this.SERVER_NOT_AVAILABLE_CONTENT)).build());
                    NextAction nextAction = ctx.getStopAction();
                    return nextAction;
                }
                if (request.requiresAcknowledgement()) {
                    HttpResponsePacket.Builder responsePacketBuilder = HttpResponsePacket.builder((HttpRequestPacket)request);
                    if ("100-continue".equalsIgnoreCase(request.getHeader("Expect"))) {
                        responsePacketBuilder.status(HttpStatus.CONINTUE_100.getStatusCode());
                        responsePacketBuilder.reasonPhrase(HttpStatus.CONINTUE_100.getReasonPhrase());
                        HttpResponsePacket packet = responsePacketBuilder.build();
                        packet.setAcknowledgement(true);
                        ctx.write((Object)packet);
                        NextAction nextAction = ctx.getStopAction();
                        return nextAction;
                    }
                    responsePacketBuilder.status(HttpStatus.EXPECTATION_FAILED_417.getStatusCode());
                    responsePacketBuilder.reasonPhrase(HttpStatus.EXPECTATION_FAILED_417.getReasonPhrase());
                    responsePacketBuilder.header("Content-Length", "0");
                    ctx.write((Object)responsePacketBuilder.build());
                    NextAction packet = ctx.getStopAction();
                    return packet;
                }
                GrizzlyHttpRequestAdapter httpRequest = new GrizzlyHttpRequestAdapter(ctx, httpContent, localAddress);
                DefaultHttpRequestContext requestContext = this.createRequestContext(ctx, ctx.getAttributes().getAttribute(HttpConstants.Protocol.HTTPS.getScheme()) == null ? HttpConstants.Protocol.HTTP.getScheme() : HttpConstants.Protocol.HTTPS.getScheme(), httpRequest);
                RequestHandler requestHandler = this.requestHandlerProvider.getRequestHandler(serverAddress, httpRequest);
                requestHandler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)new GrizzlyHttpResponseReadyCallback(httpRequest, ctx, requestHandler, request));
                NextAction nextAction = ctx.getSuspendAction();
                return nextAction;
            }
            NextAction nextAction = ctx.getInvokeAction();
            return nextAction;
        }
        finally {
            serverCounter.decrementAndGet();
        }
    }

    private DefaultHttpRequestContext createRequestContext(FilterChainContext ctx, String scheme, GrizzlyHttpRequestAdapter httpRequest) {
        SSLSession sslSession = (SSLSession)ctx.getAttributes().getAttribute("muleSslSession");
        DefaultClientConnection clientConnection = sslSession != null ? new DefaultClientConnection(sslSession, (InetSocketAddress)ctx.getConnection().getPeerAddress()) : new DefaultClientConnection((InetSocketAddress)ctx.getConnection().getPeerAddress());
        DefaultServerConnection serverConnection = new DefaultServerConnection((InetSocketAddress)ctx.getConnection().getLocalAddress());
        return new DefaultHttpRequestContext(scheme, httpRequest, clientConnection, serverConnection);
    }

    public int activeRequestsFor(ServerAddress serverAddress) {
        AtomicInteger addressActiveRequests = (AtomicInteger)this.activeRequests.get(serverAddress);
        return addressActiveRequests == null ? 0 : addressActiveRequests.get();
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        HttpHeader header;
        if (event.type() == HttpEvents.IncomingHttpUpgradeEvent.TYPE && (header = ((HttpEvents.IncomingHttpUpgradeEvent)event).getHttpHeader()).isRequest()) {
            header.setIgnoreContentModifiers(this.isWebSocketUpgrade(header));
            return ctx.getStopAction();
        }
        if (event.type() == HttpEvents.OutgoingHttpUpgradeEvent.TYPE) {
            HttpEvents.OutgoingHttpUpgradeEvent outUpgradeEvent = (HttpEvents.OutgoingHttpUpgradeEvent)event;
            outUpgradeEvent.getHttpHeader().setIgnoreContentModifiers(false);
            return ctx.getStopAction();
        }
        return super.handleEvent(ctx, event);
    }

    private boolean isWebSocketUpgrade(HttpHeader header) {
        String upgrade = header.getHeader("upgrade");
        return "WebSocket".equalsIgnoreCase(upgrade);
    }
}

