/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.internal.utils;

import java.util.Optional;
import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.xs.XSAttributeUse;
import org.mule.apache.xerces.xs.XSElementDeclaration;
import org.mule.apache.xerces.xs.XSFacet;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObject;
import org.mule.apache.xerces.xs.XSObjectList;

public class SchemaHelper {
    public static Optional<String> getDefaultValue(XSElementDeclaration element) {
        return Optional.ofNullable(element.getConstraintValue());
    }

    public static Optional<String> getDefaultValue(XSAttributeUse attributeDeclaration) {
        return Optional.ofNullable(attributeDeclaration.getConstraintValue());
    }

    public static Integer getIntegerValue(XSObject patternFacetObject) {
        XSFacet minLengthFacet = (XSFacet)patternFacetObject;
        String lexicalFacetValues = minLengthFacet.getLexicalFacetValue();
        if (lexicalFacetValues != null && !lexicalFacetValues.isEmpty()) {
            return Integer.parseInt(lexicalFacetValues);
        }
        return -1;
    }

    public static Double getDoubleValue(XSObject patternFacetObject) {
        XSFacet minLengthFacet = (XSFacet)patternFacetObject;
        String lexicalFacetValues = minLengthFacet.getLexicalFacetValue();
        if (lexicalFacetValues != null && !lexicalFacetValues.isEmpty()) {
            return Double.parseDouble(lexicalFacetValues);
        }
        return 1.0;
    }

    public static XSObject getFacet(XSSimpleTypeDecl element, int facetType) {
        if (facetType == 2048 || facetType == 8) {
            XSObjectList list = element.getMultiValueFacets();
            for (int i = 0; i < list.getLength(); ++i) {
                XSMultiValueFacet f = (XSMultiValueFacet)list.item(i);
                if (f.getFacetKind() != facetType) continue;
                return f;
            }
        } else {
            XSObjectList list = element.getFacets();
            for (int i = 0; i < list.getLength(); ++i) {
                XSFacet f = (XSFacet)list.item(i);
                if (f.getFacetKind() != facetType) continue;
                return f;
            }
        }
        return null;
    }
}

