/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.object.factory;

import java.util.Iterator;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.object.CursorIterator;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.core.internal.event.EventUtils;

public abstract class AbstractCursorIteratorProviderFactory
implements CursorIteratorProviderFactory {
    protected final StreamingManager streamingManager;
    protected static final boolean trackCursorProviderClose = Boolean.getBoolean("mule.track.cursorProvider.close");

    public AbstractCursorIteratorProviderFactory(StreamingManager streamingManager) {
        this.streamingManager = streamingManager;
    }

    @Override
    public final Object of(EventContext eventContext, Iterator iterator, ComponentLocation originatingLocation) {
        if (iterator instanceof CursorIterator) {
            return this.streamingManager.manage(((CursorIterator)iterator).getProvider(), eventContext);
        }
        Object value = this.resolve(iterator, eventContext, originatingLocation);
        if (value instanceof CursorProvider) {
            value = this.streamingManager.manage((CursorProvider)value, eventContext);
        }
        return value;
    }

    @Override
    public final Object of(EventContext eventContext, Iterator iterator) {
        return this.of(eventContext, iterator, (ComponentLocation)null);
    }

    @Override
    public final Object of(CoreEvent event, Iterator value, ComponentLocation originatingLocation) {
        return this.of(EventUtils.getRoot(event.getContext()), value, originatingLocation);
    }

    @Override
    public final Object of(CoreEvent event, Iterator value) {
        return this.of(EventUtils.getRoot(event.getContext()), value, (ComponentLocation)null);
    }

    protected abstract Object resolve(Iterator var1, EventContext var2, ComponentLocation var3);

    @Override
    public boolean accepts(Object value) {
        return value instanceof Iterator;
    }
}

