/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.policy;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.policy.PolicyPointcut;

public final class PolicyParametrization {
    private final String id;
    private final org.mule.runtime.policy.api.PolicyPointcut pointcut;
    private final Map<String, String> parameters;
    private final int order;
    private final File config;
    private final List<NotificationListener> notificationListeners;

    public PolicyParametrization(String id, org.mule.runtime.policy.api.PolicyPointcut pointcut, int order, Map<String, String> parameters, File config, List<NotificationListener> notificationListeners) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)id) ? 1 : 0) != 0, (String)"id cannot be null");
        Preconditions.checkArgument((pointcut != null ? 1 : 0) != 0, (String)"pointcut cannot be null");
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (String)"parameters cannot be null");
        Preconditions.checkArgument((order > 0 ? 1 : 0) != 0, (String)"order must be positive");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (String)"config file cannot be null");
        Preconditions.checkArgument((notificationListeners != null ? 1 : 0) != 0, (String)"notification listeners cannot be null");
        this.id = id;
        this.pointcut = pointcut;
        this.parameters = Collections.unmodifiableMap(parameters);
        this.order = order;
        this.config = config;
        this.notificationListeners = Collections.unmodifiableList(notificationListeners);
    }

    @Deprecated
    public PolicyParametrization(String id, PolicyPointcut pointcut, int order, Map<String, String> parameters, File config, List<NotificationListener> notificationListeners) {
        this(id, (org.mule.runtime.policy.api.PolicyPointcut)pointcut, order, parameters, config, notificationListeners);
    }

    public String getId() {
        return this.id;
    }

    @Deprecated
    public PolicyPointcut getPointcut() {
        return (PolicyPointcut)this.pointcut;
    }

    public org.mule.runtime.policy.api.PolicyPointcut getPolicyPointcut() {
        return this.pointcut;
    }

    public int getOrder() {
        return this.order;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public File getConfig() {
        return this.config;
    }

    public List<NotificationListener> getNotificationListeners() {
        return this.notificationListeners;
    }
}

