/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.mule.weave.v2.core.exception.UnsupportedBasePropertyException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.core.util.BinaryHelper$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.values.BinaryValue;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;

public final class BinaryCoercer$
implements ValueCoercer<BinaryValue> {
    public static BinaryCoercer$ MODULE$;

    static {
        new BinaryCoercer$();
    }

    @Override
    public Option<BinaryValue> coerceMaybe(Value<?> value, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetSchema, locationCapable, evaluationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BinaryValue coerce(Value<?> c, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        byte[] byArray;
        Value<?> value = c;
        if (BinaryType$.MODULE$.accepts(value, ctx)) {
            SeekableStream inputStream = (SeekableStream)c.evaluate(ctx);
            return BinaryValue$.MODULE$.apply(inputStream, locationCapable, targetSchema);
        }
        if (NumberType$.MODULE$.accepts(value, ctx)) {
            byte[] bytes = new byte[]{((Number)NumberType$.MODULE$.coerce(c, ctx).evaluate(ctx)).toByte()};
            return BinaryValue$.MODULE$.apply(bytes, locationCapable, targetSchema);
        }
        if (!StringType$.MODULE$.accepts(value, ctx)) throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(ctx), BinaryType$.MODULE$, c, ctx);
        Option maybeBase = targetSchema.flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.base(ctx));
        if (maybeBase.isDefined()) {
            String base = (String)maybeBase.get();
            String string = base;
            if ("64".equals(string)) {
                String base64String = StringType$.MODULE$.coerce(c, ctx).evaluate(ctx).toString();
                byArray = BinaryHelper$.MODULE$.fromBase64String(base64String, locationCapable);
            } else {
                if (!"16".equals(string)) throw new UnsupportedBasePropertyException(((LocationCapable)((Schema)targetSchema.get()).valueOf(Schema$.MODULE$.BASE_PROPERTY_NAME(), ctx).get()).location(), BinaryType$.MODULE$, StringType$.MODULE$, string, ctx);
                byArray = BinaryHelper$.MODULE$.fromHexString(StringType$.MODULE$.coerce(c, ctx).evaluate(ctx).toString(), locationCapable);
            }
        } else {
            try {
                Charset charset = (Charset)targetSchema.flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.encoding(ctx).map((Function1 & Serializable & scala.Serializable)x$1 -> Charset.forName(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ctx.serviceManager().charsetProviderService().defaultCharset());
                byArray = StringType$.MODULE$.coerce(c, ctx).evaluate(ctx).toString().getBytes(charset);
            }
            catch (UnsupportedCharsetException e) {
                throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", (Option<String>)new Some((Object)new StringBuilder(24).append("Unsupported Charset: `").append(e.getMessage()).append("`.").toString()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
            }
            catch (IllegalCharsetNameException e) {
                throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", (Option<String>)new Some((Object)new StringBuilder(19).append("Illegal Charset:`").append(e.getMessage()).append("`.").toString()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
            }
            catch (Throwable e) {
                throw new UnsupportedTypeCoercionException(locationCapable.location(), c.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "", (Option<String>)new Some((Object)e.getMessage()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
            }
        }
        byte[] bytes = byArray;
        return BinaryValue$.MODULE$.apply(bytes, locationCapable, targetSchema);
    }

    private BinaryCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
    }
}

