/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes.factory;

import java.io.InputStream;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamConfig;
import org.mule.runtime.core.api.streaming.bytes.InMemoryCursorStreamProvider;
import org.mule.runtime.core.api.streaming.bytes.factory.AbstractCursorStreamProviderFactory;

@NoExtend
public class InMemoryCursorStreamProviderFactory
extends AbstractCursorStreamProviderFactory {
    private final InMemoryCursorStreamConfig config;

    public InMemoryCursorStreamProviderFactory(ByteBufferManager bufferManager, InMemoryCursorStreamConfig config, StreamingManager streamingManager) {
        super(bufferManager, streamingManager);
        this.config = config;
    }

    @Override
    protected Object resolve(InputStream inputStream, EventContext eventContext, ComponentLocation originatingLocation) {
        return this.doResolve(inputStream, originatingLocation);
    }

    @Override
    protected Object resolve(InputStream inputStream, CoreEvent event, ComponentLocation originatingLocation) {
        return this.doResolve(inputStream, originatingLocation);
    }

    private Object doResolve(InputStream inputStream, ComponentLocation originatingLocation) {
        return new InMemoryCursorStreamProvider(inputStream, this.config, this.getBufferManager(), originatingLocation, trackCursorProviderClose);
    }
}

