/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.validation.ScopePhaseValidationItem;
import org.mule.runtime.api.el.validation.ScopePhaseValidationItemKind;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.MuleSdkOperationValidation;
import org.mule.runtime.config.internal.validation.ValidationUtils;
import org.mule.runtime.core.internal.expression.util.ExpressionUtils;

public class MuleSdkOperationDoesNotHaveForbiddenFunctionsInExpressions
extends MuleSdkOperationValidation {
    private final ExpressionLanguage expressionLanguage;
    private static final String SINCE_PARAMETER = "since";
    private static final String FUNCTION_PARAMETER = "function";
    private static final MuleVersion DEPRECATE_UP_TO = new MuleVersion("2.5.0");
    private static final Set<String> DEPRECATION_DOMAINS = ImmutableSet.of((Object)"dw", (Object)"Mule");

    public MuleSdkOperationDoesNotHaveForbiddenFunctionsInExpressions(ExpressionLanguage el) {
        this.expressionLanguage = el;
    }

    public String getName() {
        return "Mule SDK Operation doesn't have deprecated expressions";
    }

    public String getDescription() {
        return "The Mule SDK operation does not have a function as deprecated prior to DW 2.5 within itself";
    }

    private boolean isDeprecableProduct(ScopePhaseValidationItem warning) {
        String product = ((String)warning.getParams().get(FUNCTION_PARAMETER)).split("\\::")[0];
        return DEPRECATION_DOMAINS.contains(product);
    }

    private boolean isDeprecatedVersion(ScopePhaseValidationItem warning) {
        MuleVersion since = new MuleVersion((String)warning.getParams().get(SINCE_PARAMETER));
        return since.sameAs(DEPRECATE_UP_TO) || since.priorTo(DEPRECATE_UP_TO);
    }

    private boolean isInvalidExpression(ScopePhaseValidationItem warning) {
        return warning.getKind().equals((Object)ScopePhaseValidationItemKind.DEPRECATED) && this.isDeprecatedVersion(warning) && this.isDeprecableProduct(warning);
    }

    private List<ScopePhaseValidationItem> getWarningMessages(String expression) {
        String actualExpression = ExpressionUtils.getUnfixedExpression(expression);
        return this.expressionLanguage.collectScopePhaseValidationMessages(actualExpression, "", TypeBindings.builder().build()).getWarnings().stream().filter(this::isInvalidExpression).collect(Collectors.toList());
    }

    private List<ComponentParameterAst> getAllExpressions(ParameterizedModel model, ComponentAst componentAst) {
        return model.getParameterGroupModels().stream().flatMap(groupModel -> groupModel.getParameterModels().stream().filter(parameter -> !parameter.getExpressionSupport().equals((Object)ExpressionSupport.NOT_SUPPORTED)).map(parameter -> componentAst.getParameter(groupModel.getName(), parameter.getName()))).filter(param -> param.getRawValue() != null && ExpressionUtils.isExpression(param.getRawValue())).collect(Collectors.toList());
    }

    private List<Pair<ComponentParameterAst, ScopePhaseValidationItem>> getExpressionsWithWarnings(ComponentAst component) {
        ArrayList expressions = new ArrayList();
        component.recursiveStream().forEach(componentAst -> componentAst.getModel(ParameterizedModel.class).map(model -> this.getAllExpressions((ParameterizedModel)model, (ComponentAst)componentAst)).ifPresent(expressions::addAll));
        ArrayList<Pair<ComponentParameterAst, ScopePhaseValidationItem>> warnings = new ArrayList<Pair<ComponentParameterAst, ScopePhaseValidationItem>>();
        for (ComponentParameterAst param : expressions) {
            for (ScopePhaseValidationItem item : this.getWarningMessages(param.getRawValue())) {
                warnings.add((Pair<ComponentParameterAst, ScopePhaseValidationItem>)new Pair((Object)param, (Object)item));
            }
        }
        return warnings;
    }

    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return this.getExpressionsWithWarnings(component).stream().map(pair -> ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)((ComponentParameterAst)pair.getFirst()), (Validation)this, (String)("Using an invalid function within a Mule SDK operation. All functions deprecated up to DataWeave 2.5 cannot be used inside a Mule Operation. Expression: " + ((ComponentParameterAst)pair.getFirst()).getRawValue()), ValidationUtils.locationToAdditionalData(((ScopePhaseValidationItem)pair.getSecond()).getLocation()))).collect(Collectors.toList());
    }
}

