/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.server;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.service.http.test.netty.tck.ExecutorRule;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.TcpTextClient;

@Issue(value="W-17408113")
public class HalfTcpShutdownTestCase
extends AbstractHttpServerTestCase {
    @ClassRule
    public static ExecutorRule executorRule = new ExecutorRule();

    public HalfTcpShutdownTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Before
    public void setup() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/test", (requestContext, responseCallback) -> {
            try {
                String asString = IOUtils.toString((InputStream)requestContext.getRequest().getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)new StringHttpEntity(asString)), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
            catch (IOException e) {
                responseCallback.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR, (HttpEntity)new StringHttpEntity(e.toString())), (ResponseStatusCallback)new NoOpResponseStatusCallback());
            }
        });
    }

    @Override
    protected String getServerName() {
        return "test-server";
    }

    @Test
    public void halfShutdownClient() throws IOException {
        try (TcpTextClient tcpTextClient = new TcpTextClient("localhost", this.port.getNumber());){
            tcpTextClient.sendString("POST /test HTTP/1.1\nHost: localhost: %d\nTransfer-Encoding: chunked\n\n2\nOK\n0\n\n".formatted(this.port.getNumber()));
            tcpTextClient.shutdownWrite();
            MatcherAssert.assertThat((Object)tcpTextClient.receiveUntil("\r\n\r\n"), (Matcher)Matchers.containsString((String)"content-length: 2"));
            MatcherAssert.assertThat((Object)tcpTextClient.receive(2), (Matcher)Matchers.containsString((String)"OK"));
        }
    }
}

