/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.providers.grizzly.PauseHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;

public class GrizzlyResponseBodyPart
extends HttpResponseBodyPart {
    private final HttpContent content;
    private final FilterChainContext context;
    private final AtomicReference<byte[]> contentBytes = new AtomicReference();

    public GrizzlyResponseBodyPart(HttpContent content, FilterChainContext context) {
        super(false);
        this.content = content;
        this.context = context;
    }

    @Deprecated
    public GrizzlyResponseBodyPart(HttpContent content, Connection connection) {
        super(false);
        this.content = content;
        this.context = null;
    }

    @Override
    public byte[] getBodyPartBytes() {
        byte[] bytes = this.contentBytes.get();
        if (bytes != null) {
            return bytes;
        }
        Buffer b = this.content.getContent();
        int origPos = b.position();
        bytes = new byte[b.remaining()];
        b.get(bytes);
        b.flip();
        b.position(origPos);
        this.contentBytes.compareAndSet(null, bytes);
        return bytes;
    }

    @Override
    public int writeTo(OutputStream outputStream) throws IOException {
        byte[] bytes = this.getBodyPartBytes();
        outputStream.write(this.getBodyPartBytes());
        return bytes.length;
    }

    @Override
    public ByteBuffer getBodyByteBuffer() {
        return ByteBuffer.wrap(this.getBodyPartBytes());
    }

    @Override
    public boolean isLast() {
        return this.content.isLast();
    }

    @Override
    public void markUnderlyingConnectionAsToBeClosed() {
        this.content.getHttpHeader().getProcessingState().setKeepAlive(false);
    }

    @Override
    public boolean isUnderlyingConnectionToBeClosed() {
        return this.content.getHttpHeader().getProcessingState().isStayAlive();
    }

    Buffer getBodyBuffer() {
        return this.content.getContent();
    }

    @Override
    public int length() {
        return this.content.getContent().remaining();
    }

    @Override
    public PauseHandler getPauseHandler() {
        return new PauseHandler(this.context);
    }
}

