/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.IteratorFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIterator;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public final class IteratorFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<IteratorFunction> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorFunctionBuiltins();

    IteratorFunctionBuiltins() {
        super(JSIterator.CLASS_NAME, IteratorFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, IteratorFunction builtinEnum) {
        switch (builtinEnum) {
            case from: {
                return IteratorFunctionBuiltinsFactory.JSIteratorFromNodeGen.create(context, builtin, IteratorFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum IteratorFunction implements BuiltinEnum<IteratorFunction>
    {
        from(1);

        private final int length;

        private IteratorFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSIteratorFromNode
    extends JSBuiltinNode {
        @Node.Child
        private GetIteratorFlattenableNode getIteratorFlattenableNode;
        @Node.Child
        private InstanceofNode.OrdinaryHasInstanceNode ordinaryHasInstanceNode;

        public JSIteratorFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(false, context);
            this.ordinaryHasInstanceNode = InstanceofNode.OrdinaryHasInstanceNode.create(context);
        }

        @Specialization
        protected JSDynamicObject iteratorFrom(Object arg) {
            IteratorRecord iteratorRecord = this.getIteratorFlattenableNode.execute(arg);
            JSRealm realm = this.getRealm();
            boolean hasInstance = this.ordinaryHasInstanceNode.executeBoolean((Object)iteratorRecord.getIterator(), (Object)realm.getIteratorConstructor());
            if (hasInstance) {
                return iteratorRecord.getIterator();
            }
            return JSWrapForValidIterator.create(this.getContext(), realm, iteratorRecord);
        }
    }
}

