/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.client;

import io.qameta.allure.Issue;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.rule.DynamicPort;

public class NettyHttpClientHeaderLimitTestCase {
    private static final int CONNECTION_IDLE_TIMEOUT = 1000;
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_CLIENT_REQUEST_HEADERS_KEY = "mule.http.MAX_CLIENT_REQUEST_HEADERS";
    private HttpClient client;
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestHttpServer testServer = new TestHttpServer("localhost", this.serverPort.getNumber(), false);

    @Before
    public void setUp() throws Exception {
        this.client = NettyHttpClient.builder().withConnectionIdleTimeout(1000).withUsingPersistentConnections(true).build();
        this.client.start();
        this.testServer.addRequestHandler("/hello", (request, responseSender) -> {
            StringHttpEntity helloContent = new StringHttpEntity("Hello from server!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
    }

    @After
    public void tearDown() {
        this.client.stop();
    }

    @Issue(value="W-15642768")
    @Test
    public void testMaxClientRequestHeaders() throws Exception {
        MatcherAssert.assertThat((Object)NettyHttpClient.getMaxClientRequestHeaders(), (Matcher)Matchers.equalTo((Object)100));
        System.setProperty(MAX_CLIENT_REQUEST_HEADERS_KEY, "3");
        NettyHttpClient.refreshSystemProperties();
        HttpRequest httpRequest = ((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/test", this.serverPort.getNumber())).method("GET").addHeader("Header1", "Value1")).addHeader("Header2", "Value2")).addHeader("Header3", "Value3")).addHeader("Header4", "Value4")).build();
        try {
            this.client.sendAsync(httpRequest).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalArgumentException));
            MatcherAssert.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Exceeded max client request headers limit"));
        }
        MatcherAssert.assertThat((Object)NettyHttpClient.getMaxClientRequestHeaders(), (Matcher)Matchers.equalTo((Object)3));
        System.clearProperty(MAX_CLIENT_REQUEST_HEADERS_KEY);
        NettyHttpClient.refreshSystemProperties();
    }
}

