/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.Objects;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;

public class DefaultNotificationListenerRegistry
implements NotificationListenerRegistry {
    @Inject
    private MuleContext context;

    public <N extends Notification> void registerListener(NotificationListener<N> listener) {
        Objects.requireNonNull(this.context.getNotificationManager(), CoreMessages.serverNotificationManagerNotEnabled().getMessage());
        this.context.getNotificationManager().addListener(listener);
    }

    public <N extends Notification> void registerListener(NotificationListener<N> listener, Predicate<N> selector) {
        Objects.requireNonNull(this.context.getNotificationManager(), CoreMessages.serverNotificationManagerNotEnabled().getMessage());
        Objects.requireNonNull(selector);
        this.context.getNotificationManager().addListenerSubscription(listener, selector);
    }

    public <N extends Notification> void unregisterListener(NotificationListener<N> listener) {
        if (this.context.getNotificationManager() != null) {
            this.context.getNotificationManager().removeListener(listener);
        }
    }
}

