/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.EfficientEquals;
import org.mule.metadata.internal.utils.EfficientHashCode;

public class DefaultObjectKeyType
extends BaseMetadataType
implements ObjectKeyType {
    private final Optional<QName> name;
    private final Optional<Pattern> pattern;
    private final Collection<AttributeFieldType> attributes;
    private Object[] fieldValues;
    private transient boolean hashCalculated;
    private transient int hash;

    public DefaultObjectKeyType(Optional<QName> name, Optional<Pattern> pattern, Collection<AttributeFieldType> attributes, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
        super(metadataFormat, extensions);
        this.name = name;
        this.pattern = pattern;
        this.attributes = attributes;
    }

    @Override
    public QName getName() {
        return this.name.get();
    }

    @Override
    public boolean isName() {
        return this.name.isPresent();
    }

    @Override
    public Pattern getPattern() {
        return this.pattern.get();
    }

    @Override
    public boolean isPattern() {
        return this.pattern.isPresent();
    }

    public Optional<String> getLabel() {
        return this.getAnnotation(LabelAnnotation.class).map(label -> label.getValue());
    }

    @Override
    public Collection<AttributeFieldType> getAttributes() {
        return this.attributes;
    }

    @Override
    public void accept(MetadataTypeVisitor visitor) {
        visitor.visitObjectKey(this);
    }

    @Override
    public String toString() {
        return "DefaultObjectKeyType{name: " + this.name.toString() + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultObjectKeyType)) {
            return false;
        }
        DefaultObjectKeyType that = (DefaultObjectKeyType)o;
        return EfficientEquals.efficientEquals(this, that) && this.equalPattern(this.pattern, that.pattern);
    }

    boolean equalPattern(Optional<Pattern> thisPattern, Optional<Pattern> thatPattern) {
        if (thisPattern.isPresent() != thatPattern.isPresent()) {
            return false;
        }
        if (!thisPattern.isPresent() || !thatPattern.isPresent()) {
            return true;
        }
        return thisPattern.get().toString().equals(thatPattern.get().toString());
    }

    @Override
    public int hashCode() {
        if (!this.hashCalculated) {
            this.hash = Objects.hash(EfficientHashCode.efficientHashcode(this), this.pattern.map(x -> x.toString().hashCode()).orElse(null));
            this.hashCalculated = true;
        }
        return this.hash;
    }

    @Override
    public Object[] getFieldValues() {
        if (this.fieldValues == null) {
            this.fieldValues = this.createFieldValuesArray();
        }
        return this.fieldValues;
    }

    private Object[] createFieldValuesArray() {
        ArrayList fieldValues = new ArrayList();
        Collections.addAll(fieldValues, super.getFieldValues());
        Collections.addAll(fieldValues, this.attributes, this.name);
        return fieldValues.toArray(new Object[fieldValues.size()]);
    }
}

