/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.internal.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.ast.internal.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

public class XmlNamespaceInfoProviderSupplier {
    public static List<XmlNamespaceInfoProvider> createFromExtensionModels(Set<ExtensionModel> extensionModels) {
        return ImmutableList.builder().add((Object)XmlNamespaceInfoProviderSupplier.createStaticNamespaceInfoProviders(extensionModels)).addAll(XmlNamespaceInfoProviderSupplier.discoverRuntimeXmlNamespaceInfoProvider()).addAll(XmlNamespaceInfoProviderSupplier.discoverArtifactNamespaceInfoProvider()).build();
    }

    private static List<XmlNamespaceInfoProvider> discoverArtifactNamespaceInfoProvider() {
        return XmlNamespaceInfoProvider.loadXmlNamespaceInfoProviders((ClassLoader)Thread.currentThread().getContextClassLoader()).collect(Collectors.toList());
    }

    private static List<XmlNamespaceInfoProvider> discoverRuntimeXmlNamespaceInfoProvider() {
        return XmlNamespaceInfoProvider.loadXmlNamespaceInfoProviders().collect(Collectors.toList());
    }

    private static XmlNamespaceInfoProvider createStaticNamespaceInfoProviders(Set<ExtensionModel> extensionModels) {
        List extensionNamespaces = (List)extensionModels.stream().map(ext -> new StaticXmlNamespaceInfo(ext.getXmlDslModel().getNamespace(), ext.getXmlDslModel().getPrefix())).collect(org.mule.runtime.api.util.collection.Collectors.toImmutableList());
        return new StaticXmlNamespaceInfoProvider(extensionNamespaces);
    }
}

