/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.utils;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.utils.ExtensionParsingContext;
import org.mule.metadata.java.internal.utils.ParsingSubContext;

public class ParsingContext {
    private final ExtensionParsingContext extensionParsingContext;
    private final Map<TypeVariable<?>, Type> resolvedVariables = new HashMap();
    private final Map<String, ParsingSubContext> subContexts = new HashMap<String, ParsingSubContext>();

    public ParsingContext() {
        this.extensionParsingContext = new ExtensionParsingContext();
    }

    public ParsingContext(ExtensionParsingContext extensionParsingContext) {
        this.extensionParsingContext = extensionParsingContext;
    }

    public Optional<TypeBuilder<?>> getTypeBuilder(Type type) {
        return this.extensionParsingContext.getTypeBuilder(type);
    }

    public void addTypeBuilder(Type type, TypeBuilder<?> typedObject) {
        this.extensionParsingContext.addTypeBuilder(type, typedObject);
    }

    public Map<TypeVariable<?>, Type> getResolvedVariables() {
        return Collections.unmodifiableMap(this.resolvedVariables);
    }

    public void addResolvedVariables(Map<TypeVariable<?>, Type> map) {
        for (Map.Entry<TypeVariable<?>, Type> entry : map.entrySet()) {
            if (this.resolvedVariables.containsKey(entry.getKey())) {
                if (entry.getValue() instanceof TypeVariable) continue;
                this.resolvedVariables.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.resolvedVariables.put(entry.getKey(), entry.getValue());
        }
    }

    public ParsingContext getSubContext(String subId) {
        return this.subContexts.computeIfAbsent(subId, k -> new ParsingSubContext((String)k, this));
    }
}

