/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.ApintMath;
import org.apfloat.AprationalMath;
import org.apfloat.spi.Util;

public class FixedPrecisionApcomplexHelper {
    private long precision;

    public FixedPrecisionApcomplexHelper(long precision) throws IllegalArgumentException {
        ApfloatHelper.checkPrecision(precision);
        this.precision = precision;
    }

    public Apcomplex valueOf(Apcomplex z) throws ApfloatRuntimeException {
        return z.precision(this.precision());
    }

    public Apcomplex negate(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(z).negate();
    }

    public Apcomplex conj(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(z).conj();
    }

    public Apcomplex add(Apcomplex z, Apcomplex w) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(z).add(this.setPrecision(w)));
    }

    public Apcomplex subtract(Apcomplex z, Apcomplex w) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(z).subtract(this.setPrecision(w)));
    }

    public Apcomplex multiply(Apcomplex z, Apcomplex w) throws ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(z).multiply(this.setPrecision(w)));
    }

    public Apcomplex divide(Apcomplex z, Apcomplex w) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(this.setPrecision(z).divide(this.setPrecision(w)));
    }

    public Apcomplex pow(Apcomplex z, Apcomplex w) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = ApfloatHelper.checkPow(z, w, this.precision());
        if (result != null) {
            return this.valueOf(result);
        }
        return this.exp(this.multiply(this.log(z), w));
    }

    public Apcomplex pow(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.pow(this.setPrecision(z), n));
    }

    public Apfloat arg(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.arg(this.setPrecision(z)));
    }

    public Apfloat imag(Apcomplex z) {
        return this.valueOf(z.imag());
    }

    public Apfloat real(Apcomplex z) {
        return this.valueOf(z.real());
    }

    public Apfloat abs(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.abs(this.setPrecision(z)));
    }

    public Apfloat norm(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.norm(this.setPrecision(z)));
    }

    public Apcomplex acos(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.acos(this.setPrecision(z), this.precision()));
    }

    public Apcomplex acosh(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.acosh(this.setPrecision(z), this.precision()));
    }

    public Apcomplex asin(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.asin(this.setPrecision(z)));
    }

    public Apcomplex asinh(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.asinh(this.setPrecision(z)));
    }

    public Apcomplex atan(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.atan(this.setPrecision(z)));
    }

    public Apcomplex atanh(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.atanh(this.setPrecision(z)));
    }

    public Apcomplex cbrt(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cbrt(this.setPrecision(z)));
    }

    public Apcomplex cos(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cos(this.setTrigExpPrecision(z)));
    }

    public Apcomplex cosh(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cosh(this.setExpTrigPrecision(z)));
    }

    public Apcomplex exp(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.exp(this.setExpTrigPrecision(z)));
    }

    public Apcomplex log(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.log(this.setLogarithmicPrecision(z)));
    }

    public Apcomplex log(Apcomplex z, Apcomplex w) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.log(this.setPrecision(z), this.setPrecision(w)));
    }

    public Apcomplex sin(Apcomplex z) throws ApfloatRuntimeException {
        Apcomplex result = this.checkSmallLinear(z);
        if (result != null) {
            return result;
        }
        return this.valueOf(ApcomplexMath.sin(this.setTrigExpPrecision(z)));
    }

    public Apcomplex sinh(Apcomplex z) throws ApfloatRuntimeException {
        Apcomplex result = this.checkSmallLinear(z);
        if (result != null) {
            return result;
        }
        return this.valueOf(ApcomplexMath.sinh(this.setExpTrigPrecision(z)));
    }

    public Apcomplex sqrt(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sqrt(this.setPrecision(z)));
    }

    public Apcomplex tan(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = this.checkSmallLinear(z);
        if (result != null) {
            return result;
        }
        return this.valueOf(ApcomplexMath.tanFixedPrecision(this.setTrigExpPrecision(z)));
    }

    public Apcomplex tanh(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = this.checkSmallLinear(z);
        if (result != null) {
            return result;
        }
        return this.valueOf(ApcomplexMath.tanhFixedPrecision(this.setExpTrigPrecision(z)));
    }

    public Apcomplex sinc(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sinc(this.setTrigExpPrecision(z)));
    }

    public Apcomplex agm(Apcomplex a, Apcomplex b) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.agm(this.setPrecision(a), this.setPrecision(b)));
    }

    public Apcomplex inverseRoot(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.inverseRoot(this.setPrecision(z), n));
    }

    public Apcomplex inverseRoot(Apcomplex z, long n, long k) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.inverseRoot(this.setPrecision(z), n, k));
    }

    public Apcomplex root(Apcomplex z, long n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.root(this.setPrecision(z), n));
    }

    public Apcomplex root(Apcomplex z, long n, long k) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.root(this.setPrecision(z), n, k));
    }

    public Apcomplex[] allRoots(Apcomplex z, int n) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex[] allRoots = ApcomplexMath.allRoots(this.setPrecision(z), n);
        for (int i = 0; i < allRoots.length; ++i) {
            allRoots[i] = this.valueOf(allRoots[i]);
        }
        return allRoots;
    }

    public Apcomplex scale(Apcomplex z, long scale) throws ApfloatRuntimeException {
        return ApcomplexMath.scale(this.valueOf(z), scale);
    }

    public Apcomplex w(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.w(this.setPrecision(z)));
    }

    public Apcomplex w(Apcomplex z, long k) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.w(this.setPrecision(z), k));
    }

    public Apcomplex product(Apcomplex ... z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.product(this.setPrecision(z)));
    }

    public Apcomplex sum(Apcomplex ... z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sum(this.setPrecision(z)));
    }

    public Apfloat e() throws ApfloatRuntimeException {
        return ApfloatMath.e(this.precision());
    }

    public Apfloat e(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.e(this.precision(), radix);
    }

    public Apfloat euler() throws ApfloatRuntimeException {
        return ApfloatMath.euler(this.precision());
    }

    public Apfloat euler(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.euler(this.precision(), radix);
    }

    public Apfloat catalan() throws ApfloatRuntimeException {
        return ApfloatMath.catalan(this.precision());
    }

    public Apfloat catalan(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.catalan(this.precision(), radix);
    }

    public Apfloat glaisher() throws ApfloatRuntimeException {
        return ApfloatMath.glaisher(this.precision());
    }

    public Apfloat glaisher(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.glaisher(this.precision(), radix);
    }

    public Apfloat khinchin() throws ApfloatRuntimeException {
        return ApfloatMath.khinchin(this.precision());
    }

    public Apfloat khinchin(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.khinchin(this.precision(), radix);
    }

    public Apcomplex gamma(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.gamma(this.setGammaPrecision(z)));
    }

    public Apcomplex gamma(Apcomplex a, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.gamma(this.setGammaPrecision(a), this.setPrecision(z)));
    }

    public Apcomplex gamma(Apcomplex a, Apcomplex z0, Apcomplex z1) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.gamma(this.setGammaPrecision(a), this.setPrecision(z0), this.setPrecision(z1)));
    }

    public Apcomplex logGamma(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.logGamma(this.setPrecision(z)));
    }

    public Apcomplex digamma(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.digamma(this.setPrecision(z)));
    }

    public Apcomplex polygamma(long n, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.polygamma(n, this.setPrecision(z)));
    }

    public Apcomplex beta(Apcomplex a, Apcomplex b) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.beta(this.setPrecision(a), this.setPrecision(b)));
    }

    public Apcomplex beta(Apcomplex z, Apcomplex a, Apcomplex b) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.beta(this.setPrecision(z), this.setPrecision(a), this.setPrecision(b)));
    }

    public Apcomplex beta(Apcomplex z1, Apcomplex z2, Apcomplex a, Apcomplex b) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.beta(this.setPrecision(z1), this.setPrecision(z2), this.setPrecision(a), this.setPrecision(b)));
    }

    public Apcomplex pochhammer(Apcomplex z, Apcomplex n) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.pochhammer(this.setPrecision(z), this.setPrecision(n)));
    }

    public Apfloat binomial(long n, long k) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApintMath.binomial(n, k));
    }

    public Apfloat binomial(long n, long k, int radix) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        return this.valueOf(ApintMath.binomial(n, k, radix));
    }

    public Apcomplex binomial(Apcomplex n, Apcomplex k) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.binomial(this.setGammaPrecision(n), this.setGammaPrecision(k)));
    }

    public Apfloat bernoulli(long n) throws IllegalArgumentException, ApfloatRuntimeException {
        return this.valueOf(AprationalMath.bernoulli(n));
    }

    public Apfloat bernoulli(long n, int radix) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        return this.valueOf(AprationalMath.bernoulli(n, radix));
    }

    public Apcomplex zeta(Apcomplex s) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.zeta(this.setZetaPrecision(s)));
    }

    public Apcomplex zeta(Apcomplex s, Apcomplex a) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.zeta(this.setZetaPrecision(s), this.setPrecision(a)));
    }

    public Apcomplex hypergeometric0F1(Apcomplex a, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometric0F1(this.setPrecision(a), this.setPrecision(z)));
    }

    public Apcomplex hypergeometric0F1Regularized(Apcomplex a, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometric0F1Regularized(this.setPrecision(a), this.setPrecision(z)));
    }

    public Apcomplex hypergeometric1F1(Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometric1F1(this.setPrecision(a), this.setPrecision(b), this.setPrecision(z)));
    }

    public Apcomplex hypergeometric1F1Regularized(Apcomplex a, Apcomplex b, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometric1F1Regularized(this.setPrecision(a), this.setPrecision(b), this.setPrecision(z)));
    }

    public Apcomplex hypergeometric2F1(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometric2F1(this.setPrecision(a), this.setPrecision(b), this.setPrecision(c), this.setPrecision(z)));
    }

    public Apcomplex hypergeometric2F1Regularized(Apcomplex a, Apcomplex b, Apcomplex c, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometric2F1Regularized(this.setPrecision(a), this.setPrecision(b), this.setPrecision(c), this.setPrecision(z)));
    }

    public Apcomplex hypergeometricU(Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hypergeometricU(this.setPrecision(a), this.setPrecision(b), this.setPrecision(z)));
    }

    public Apcomplex erf(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.erfFixedPrecision(this.setErfPrecision(z)));
    }

    public Apcomplex erfc(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.erfcFixedPrecision(this.setErfPrecision(z)));
    }

    public Apcomplex erfi(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.erfiFixedPrecision(this.setErfPrecision(z)));
    }

    public Apcomplex fresnelS(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.fresnelS(this.setPrecision(z)));
    }

    public Apcomplex fresnelC(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.fresnelC(this.setPrecision(z)));
    }

    public Apcomplex expIntegralE(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.expIntegralE(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex expIntegralEi(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.expIntegralEi(this.setPrecision(z)));
    }

    public Apcomplex logIntegral(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.logIntegral(this.setLogarithmicPrecision(z)));
    }

    public Apcomplex sinIntegral(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sinIntegral(this.setPrecision(z)));
    }

    public Apcomplex cosIntegral(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.cosIntegral(this.setPrecision(z)));
    }

    public Apcomplex sinhIntegral(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sinhIntegral(this.setPrecision(z)));
    }

    public Apcomplex coshIntegral(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.coshIntegral(this.setPrecision(z)));
    }

    public Apcomplex airyAi(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.airyAi(this.setPrecision(z), this.precision()));
    }

    public Apcomplex airyAiPrime(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.airyAiPrime(this.setPrecision(z), this.precision()));
    }

    public Apcomplex airyBi(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.airyBi(this.setPrecision(z), this.precision()));
    }

    public Apcomplex airyBiPrime(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.airyBiPrime(this.setPrecision(z), this.precision()));
    }

    public Apcomplex besselJ(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.besselJ(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex besselI(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.besselI(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex besselY(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.besselY(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex besselK(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.besselK(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex ellipticK(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.ellipticK(this.setPrecision(z), this.precision()));
    }

    public Apcomplex ellipticE(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.ellipticE(this.setPrecision(z), this.precision()));
    }

    public Apcomplex hermiteH(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.hermiteH(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex laguerreL(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.laguerreL(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex laguerreL(Apcomplex \u03bd, Apcomplex \u03bb, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.laguerreL(this.setPrecision(\u03bd), this.setPrecision(\u03bb), this.setPrecision(z)));
    }

    public Apcomplex legendreP(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.legendreP(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex legendreP(Apcomplex \u03bd, Apcomplex \u03bc, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.legendreP(this.setPrecision(\u03bd), this.setPrecision(\u03bc), this.setPrecision(z)));
    }

    public Apcomplex legendreQ(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.legendreQ(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex legendreQ(Apcomplex \u03bd, Apcomplex \u03bc, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.legendreQ(this.setPrecision(\u03bd), this.setPrecision(\u03bc), this.setPrecision(z)));
    }

    public Apcomplex sphericalHarmonicY(Apcomplex \u03bb, Apcomplex \u03bc, Apcomplex \u03d1, Apcomplex \u03d5) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.sphericalHarmonicY(this.setPrecision(\u03bb), this.setPrecision(\u03bc), this.setPrecision(\u03d1), this.setPrecision(\u03d5)));
    }

    public Apcomplex chebyshevT(Apcomplex \u03bd, Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.chebyshevT(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex chebyshevU(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.chebyshevU(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex gegenbauerC(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.gegenbauerC(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex gegenbauerC(Apcomplex \u03bd, Apcomplex \u03bb, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.gegenbauerC(this.setPrecision(\u03bd), this.setPrecision(\u03bb), this.setPrecision(z)));
    }

    public Apcomplex jacobiP(Apcomplex \u03bd, Apcomplex a, Apcomplex b, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.jacobiP(this.setPrecision(\u03bd), this.setPrecision(a), this.setPrecision(b), this.setPrecision(z)));
    }

    public Apcomplex fibonacci(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.fibonacci(new Apcomplex(this.setTrigonometricPrecision(\u03bd.real()), this.setTrigonometricPrecision(\u03bd.imag())), this.setPrecision(z)));
    }

    public Apcomplex eulerE(long n, Apcomplex z) throws IllegalArgumentException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.eulerE(n, this.setPrecision(z), this.precision()));
    }

    public Apcomplex bernoulliB(long n, Apcomplex z) throws IllegalArgumentException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.bernoulliB(n, this.setPrecision(z), this.precision()));
    }

    public Apcomplex harmonicNumber(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.harmonicNumber(this.setPrecision(z)));
    }

    public Apcomplex harmonicNumber(Apcomplex z, Apcomplex r) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.harmonicNumber(this.setPrecision(z), this.setPrecision(r)));
    }

    public Apcomplex polylog(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.polylog(this.setPrecision(\u03bd), this.setPrecision(z)));
    }

    public Apcomplex logisticSigmoid(Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.logisticSigmoid(this.setExpTrigPrecision(z)));
    }

    public Apfloat ulp(Apcomplex z) throws ApfloatRuntimeException {
        return this.valueOf(ApcomplexMath.ulp(this.setPrecision(z)));
    }

    public long precision() {
        return this.precision;
    }

    Apfloat valueOf(Apfloat x) throws ApfloatRuntimeException {
        return x.precision(this.precision());
    }

    Apfloat pi() throws ApfloatRuntimeException {
        return ApfloatMath.pi(this.precision());
    }

    Apfloat pi(int radix) throws NumberFormatException, ApfloatRuntimeException {
        return ApfloatMath.pi(this.precision(), radix);
    }

    Apfloat setTrigonometricPrecision(Apfloat x) throws ApfloatRuntimeException {
        long precision = ApfloatHelper.extendPrecision(this.precision(), Math.max(0L, x.scale()));
        return x.precision(precision);
    }

    Apfloat setExponentialPrecision(Apfloat x) throws ApfloatRuntimeException {
        if (x.scale() <= -this.precision()) {
            x = new Apfloat(0L, Long.MIN_VALUE, x.radix());
        } else if (x.scale() < 0L) {
            long precision = Util.ifFinite(this.precision(), this.precision() + x.scale());
            x = x.precision(precision);
        } else if (x.scale() > 1L) {
            long precision = Util.ifFinite(this.precision(), this.precision() + x.scale() - 1L);
            x = x.precision(precision);
        } else {
            x = x.precision(this.precision());
        }
        return x;
    }

    Apfloat setLogarithmicPrecision(Apfloat x) throws ApfloatRuntimeException {
        long precision = ApfloatHelper.extendPrecision(this.precision(), x.equalDigits(new Apfloat(1L, Long.MAX_VALUE, x.radix())));
        return x.precision(precision);
    }

    Apfloat setGammaPrecision(Apfloat x) {
        return this.setGammaPrecision((Apcomplex)x).real();
    }

    Apfloat setZetaPrecision(Apfloat x) {
        return this.setTrigonometricPrecision(x);
    }

    Apfloat setErfPrecision(Apfloat x) {
        return this.setErfPrecision((Apcomplex)x).real();
    }

    private Apcomplex setPrecision(Apcomplex z) throws ApfloatRuntimeException {
        return z.precision(this.precision());
    }

    private Apcomplex[] setPrecision(Apcomplex[] z) throws ApfloatRuntimeException {
        Apcomplex[] tmp = new Apcomplex[z.length];
        for (int i = 0; i < z.length; ++i) {
            tmp[i] = this.setPrecision(z[i]);
        }
        return tmp;
    }

    private Apcomplex setExpTrigPrecision(Apcomplex z) {
        return new Apcomplex(this.setExponentialPrecision(z.real()), this.setTrigonometricPrecision(z.imag()));
    }

    private Apcomplex setTrigExpPrecision(Apcomplex z) {
        return new Apcomplex(this.setTrigonometricPrecision(z.real()), this.setExponentialPrecision(z.imag()));
    }

    private Apcomplex setLogarithmicPrecision(Apcomplex z) {
        long precision = ApfloatHelper.extendPrecision(this.precision(), this.abs(z).equalDigits(new Apfloat(1L, Long.MAX_VALUE, z.radix())));
        return z.precision(precision);
    }

    private Apcomplex setGammaPrecision(Apcomplex z) {
        long precision = ApfloatHelper.extendPrecision(this.precision(), Math.max(0L, z.scale()));
        return ApfloatHelper.ensureGammaPrecision(z, precision);
    }

    private Apcomplex setZetaPrecision(Apcomplex z) {
        return new Apcomplex(this.setZetaPrecision(z.real()), this.setTrigonometricPrecision(z.imag()));
    }

    private Apcomplex setErfPrecision(Apcomplex z) {
        long precision = this.precision();
        long scale = z.scale();
        if (scale > 0L) {
            precision = ApfloatHelper.extendPrecision(precision, Util.ifFinite(scale, 2L * scale));
        }
        return z.precision(precision);
    }

    private Apcomplex checkSmallLinear(Apcomplex z) {
        if (z.scale() <= -this.precision()) {
            return this.setPrecision(z);
        }
        return null;
    }
}

