/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;

public final class ExecutionTypeDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        return Optional.of(new IdempotentDeclarationEnricherWalkDelegate(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                declaration.setExecutionType(ExecutionTypeDeclarationEnricher.this.resolve(declaration));
            }
        });
    }

    private ExecutionType resolve(OperationDeclaration declaration) {
        ExecutionType executionType = declaration.getExecutionType();
        if (executionType != null) {
            return executionType;
        }
        if (declaration.isRequiresConnection()) {
            return declaration.isBlocking() ? ExecutionType.BLOCKING : ExecutionType.CPU_LITE;
        }
        return ExecutionType.CPU_LITE;
    }
}

