/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.server.grizzly;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseEndpointManager;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.service.http.common.server.sse.SseHandlerManagerAdapter;
import org.mule.service.http.common.server.sse.SseRequestHandler;
import org.mule.service.http.impl.service.server.HttpListenerRegistry;
import org.mule.service.http.impl.service.server.grizzly.GrizzlyAddressFilter;
import org.mule.service.http.impl.service.server.grizzly.MuleSslFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyHttpServer
implements HttpServer,
Supplier<ExecutorService> {
    protected static final Logger logger = LoggerFactory.getLogger(GrizzlyHttpServer.class);
    private static boolean REPLACE_CONTEXT_CLASSLOADER = System.getProperty("mule.disableLogSeparation") == null;
    private final TCPNIOTransport transport;
    private final ServerAddress serverAddress;
    private final HttpListenerRegistry listenerRegistry;
    private TCPNIOServerConnection serverConnection;
    private GrizzlyAddressFilter<SSLFilter> sslFilter;
    private Supplier<Scheduler> schedulerSource;
    private Runnable schedulerDisposer;
    private Scheduler scheduler;
    private boolean stopped = true;
    private boolean stopping;
    private Supplier<Long> shutdownTimeoutSupplier;
    private CountAcceptedConnectionsProbe acceptedConnectionsProbe;
    private final List<Connection<?>> clientConnections = Collections.synchronizedList(new LinkedList());

    public GrizzlyHttpServer(ServerAddress serverAddress, TCPNIOTransport transport, HttpListenerRegistry listenerRegistry, Supplier<Scheduler> schedulerSource, Runnable schedulerDisposer, GrizzlyAddressFilter<SSLFilter> sslFilter, Supplier<Long> shutdownTimeoutSupplier) {
        this.serverAddress = serverAddress;
        this.transport = transport;
        this.listenerRegistry = listenerRegistry;
        this.schedulerSource = schedulerSource;
        this.schedulerDisposer = schedulerDisposer;
        this.sslFilter = sslFilter;
        this.shutdownTimeoutSupplier = shutdownTimeoutSupplier;
    }

    public synchronized HttpServer start() throws IOException {
        this.scheduler = this.schedulerSource != null ? this.schedulerSource.get() : null;
        this.serverConnection = this.transport.bind(this.serverAddress.getIp(), this.serverAddress.getPort());
        this.acceptedConnectionsProbe = new CountAcceptedConnectionsProbe();
        this.serverConnection.getMonitoringConfig().addProbes((Object[])new ConnectionProbe[]{this.acceptedConnectionsProbe});
        if (logger.isInfoEnabled()) {
            logger.info("Listening for connections on '{}'", (Object)this.listenerUrl());
        }
        this.serverConnection.addCloseListener((Connection.CloseListener)new OnCloseConnectionListener());
        this.stopped = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HttpServer stop() {
        if (this.stopped) {
            return this;
        }
        Long shutdownTimeout = this.shutdownTimeoutSupplier.get();
        long stopNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(shutdownTimeout);
        this.stopping = true;
        try {
            this.transport.unbind((Connection)this.serverConnection);
            if (shutdownTimeout != 0L) {
                List<Connection<?>> list = this.clientConnections;
                synchronized (list) {
                    long remainingMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - System.nanoTime());
                    while (!this.clientConnections.isEmpty() && remainingMillis > 0L) {
                        long millisToWait = Math.min(remainingMillis, 50L);
                        logger.debug("There are still {} open connections on server stop. Waiting {} milliseconds", (Object)this.clientConnections.size(), (Object)millisToWait);
                        this.clientConnections.wait(millisToWait);
                        remainingMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - System.nanoTime());
                    }
                    if (!this.clientConnections.isEmpty()) {
                        logger.warn("There are still {} open connections on server stop.", (Object)this.clientConnections.size());
                    }
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Stopped listener on '{}'", (Object)this.listenerUrl());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.stopped = true;
            this.stopping = false;
        }
        return this;
    }

    public void dispose() {
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public HttpConstants.Protocol getProtocol() {
        return this.sslFilter.hasFilterForAddress(this.getServerAddress()) ? HttpConstants.Protocol.HTTPS : HttpConstants.Protocol.HTTP;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public RequestHandlerManager addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, this.preservingTCCL(requestHandler), PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.builder(methods).build()).path(path).build());
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.listenerRegistry.addRequestHandler(this, this.preservingTCCL(requestHandler), PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }

    public SseEndpointManager sse(String ssePath, Consumer<SseRequestContext> onRequest, Consumer<SseClient> onClient) {
        return new SseHandlerManagerAdapter(this.addRequestHandler(ssePath, (RequestHandler)new SseRequestHandler(onRequest, onClient)));
    }

    private RequestHandler preservingTCCL(final RequestHandler requestHandler) {
        final ClassLoader creationClassLoader = Thread.currentThread().getContextClassLoader();
        return new RequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
                ClassLoader outerClassLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader innerClassLoader = this.getContextClassLoader();
                ClassUtils.setContextClassLoader((Thread)Thread.currentThread(), (ClassLoader)outerClassLoader, (ClassLoader)innerClassLoader);
                try {
                    requestHandler.handleRequest(requestContext, responseCallback);
                }
                finally {
                    ClassUtils.setContextClassLoader((Thread)Thread.currentThread(), (ClassLoader)innerClassLoader, (ClassLoader)outerClassLoader);
                }
            }

            public ClassLoader getContextClassLoader() {
                return REPLACE_CONTEXT_CLASSLOADER ? creationClassLoader : requestHandler.getContextClassLoader();
            }
        };
    }

    @Override
    public ExecutorService get() {
        return this.scheduler;
    }

    public void enableTls(TlsContextFactory tlsContextFactory) {
        this.sslFilter.addFilterForAddress(this.getServerAddress(), MuleSslFilter.createSslFilter(tlsContextFactory));
    }

    public void disableTls() {
        this.sslFilter.removeFilterForAddress(this.getServerAddress());
    }

    private String listenerUrl() {
        return String.format("%s://%s:%d", this.getProtocol().getScheme(), this.serverAddress.getIp(), this.serverAddress.getPort());
    }

    public static void setReplaceCtxClassloader(boolean replaceContextClassloader) {
        REPLACE_CONTEXT_CLASSLOADER = replaceContextClassloader;
    }

    @Deprecated
    public static void refreshSystemProperties() {
        REPLACE_CONTEXT_CLASSLOADER = System.getProperty("mule.disableLogSeparation") == null;
    }

    private class CountAcceptedConnectionsProbe
    extends ConnectionProbe.Adapter {
        private CountAcceptedConnectionsProbe() {
        }

        public void onAcceptEvent(Connection serverConnection, Connection clientConnection) {
            GrizzlyHttpServer.this.clientConnections.add(clientConnection);
            clientConnection.addCloseListener((closeable, iCloseType) -> {
                GrizzlyHttpServer.this.clientConnections.remove(clientConnection);
                if (GrizzlyHttpServer.this.clientConnections.isEmpty()) {
                    List<Connection<?>> list = GrizzlyHttpServer.this.clientConnections;
                    synchronized (list) {
                        if (GrizzlyHttpServer.this.clientConnections.isEmpty()) {
                            GrizzlyHttpServer.this.clientConnections.notifyAll();
                        }
                    }
                }
            });
        }
    }

    private class OnCloseConnectionListener
    implements Connection.CloseListener {
        private OnCloseConnectionListener() {
        }

        public void onClosed(Connection closeable, Connection.CloseType type) throws IOException {
            try {
                if (GrizzlyHttpServer.this.scheduler != null) {
                    GrizzlyHttpServer.this.scheduler.stop();
                }
                GrizzlyHttpServer.this.scheduler = null;
                GrizzlyHttpServer.this.schedulerDisposer.run();
            }
            catch (Throwable throwable) {
                GrizzlyHttpServer.this.scheduler = null;
                GrizzlyHttpServer.this.schedulerDisposer.run();
                closeable.removeCloseListener((Connection.CloseListener)this);
                GrizzlyHttpServer.this.serverConnection.getMonitoringConfig().removeProbes((Object[])new ConnectionProbe[]{GrizzlyHttpServer.this.acceptedConnectionsProbe});
                GrizzlyHttpServer.this.acceptedConnectionsProbe = null;
                throw throwable;
            }
            closeable.removeCloseListener((Connection.CloseListener)this);
            GrizzlyHttpServer.this.serverConnection.getMonitoringConfig().removeProbes((Object[])new ConnectionProbe[]{GrizzlyHttpServer.this.acceptedConnectionsProbe});
            GrizzlyHttpServer.this.acceptedConnectionsProbe = null;
        }
    }
}

