/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.common.message.sse;

import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import org.mule.runtime.http.api.sse.ServerSentEvent;

public class SseEntityEncoder {
    private static final String LINE_BREAK_REGEX = "\\R";

    public void writeTo(Writer writer, ServerSentEvent event) throws IOException {
        Optional optionalNewRetryDelay;
        writer.write("event: ");
        writer.write(event.getName());
        writer.write("\n");
        for (String dataLine : event.getData().split(LINE_BREAK_REGEX)) {
            writer.write("data: ");
            writer.write(dataLine);
            writer.write("\n");
        }
        Optional optionalId = event.getId();
        if (optionalId.isPresent()) {
            String id = (String)optionalId.get();
            writer.write("id: ");
            writer.write(id);
            writer.write("\n");
        }
        if ((optionalNewRetryDelay = event.getRetryDelay()).isPresent()) {
            long newDelay = (Long)optionalNewRetryDelay.get();
            writer.write("retry: " + newDelay);
            writer.write("\n");
        }
        writer.write("\n");
        writer.flush();
    }
}

