/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.impl.benchmark;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

public class BenchmarkTestServer {
    private final String host;
    private final int port;
    private final HttpListenerRegistry httpListenerRegistry;
    private ExecutorService ioExecutor = Executors.newCachedThreadPool();
    private HttpServer server;

    public BenchmarkTestServer(String host, int port) {
        this.host = host;
        this.port = port;
        this.httpListenerRegistry = new HttpListenerRegistry();
    }

    public void start() throws IOException {
        this.ioExecutor = Executors.newCachedThreadPool();
        this.server = NettyHttpServer.builder().withShutdownTimeout(() -> 5000L).withServerAddress(new InetSocketAddress(this.host, this.port)).withHttpListenerRegistry(this.httpListenerRegistry).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.httpListenerRegistry, "test-server", true, 30000, 10000L, null, this.ioExecutor)).build();
        this.server.start();
    }

    public void stop() {
        if (null != this.server) {
            this.server.stop();
            this.server = null;
        }
        if (null != this.ioExecutor) {
            this.ioExecutor.shutdownNow();
            this.ioExecutor = null;
        }
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.httpListenerRegistry.addRequestHandler(this.server, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }
}

