/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.function;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.component.execution.ExecutableComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionFunction;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.FunctionParameter;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class LookupFunction
implements ExpressionFunction {
    private static final DataType TYPED_VALUE = DataType.fromType(TypedValue.class);
    private final ConfigurationComponentLocator componentLocator;
    private final SchedulerService schedulerService;

    public LookupFunction(ConfigurationComponentLocator componentLocator, SchedulerService schedulerService) {
        this.componentLocator = componentLocator;
        this.schedulerService = schedulerService;
    }

    public Object call(Object[] parameters, BindingContext context) {
        String flowName = (String)parameters[0];
        Object payload = parameters[1];
        Integer timeout = (Integer)parameters[2];
        Location componentLocation = Location.builder().globalName(flowName).build();
        Component component = (Component)this.componentLocator.find(componentLocation).orElseThrow(() -> new IllegalArgumentException(String.format("There is no component named '%s'.", flowName)));
        if (component instanceof Flow) {
            Message incomingMessage = this.lookupValue(context, "message", Message.builder().nullValue().build());
            Map incomingVariables = this.lookupValue(context, "vars", Collections.EMPTY_MAP);
            Error incomingError = this.lookupValue(context, "error", null);
            Message message = Message.builder((Message)incomingMessage).value(payload).mediaType(MediaType.APPLICATION_JAVA).build();
            CoreEvent event = CoreEvent.builder(PrivilegedEvent.getCurrentEvent().getContext()).variables(incomingVariables).error(incomingError).message(message).build();
            CompletableFuture lookupResultFuture = null;
            try {
                lookupResultFuture = ((ExecutableComponent)component).execute((Event)event);
                return ((Event)lookupResultFuture.get(timeout.intValue(), TimeUnit.MILLISECONDS)).getMessage().getPayload();
            }
            catch (ExecutionException e) {
                ComponentExecutionException componentExecutionException = (ComponentExecutionException)e.getCause();
                Error error = (Error)componentExecutionException.getEvent().getError().get();
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Flow '%s' has failed with error '%s' (%s)", flowName, error.getErrorType(), error.getDescription())), error.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (lookupResultFuture != null) {
                    lookupResultFuture.cancel(true);
                }
                throw new MuleRuntimeException((Throwable)e);
            }
            catch (TimeoutException e) {
                if (lookupResultFuture != null) {
                    lookupResultFuture.cancel(true);
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Flow '%s' has timed out after %d millis", flowName, timeout)), (Throwable)e);
            }
        }
        throw new IllegalArgumentException(String.format("Component '%s' is not a flow.", flowName));
    }

    public Optional<DataType> returnType() {
        return Optional.of(TYPED_VALUE);
    }

    public List<FunctionParameter> parameters() {
        return Arrays.asList(new FunctionParameter("flowName", DataType.STRING), new FunctionParameter("payload", DataType.OBJECT), new FunctionParameter("timeoutMillis", DataType.NUMBER, context -> {
            if (this.schedulerService.isCurrentThreadForCpuWork()) {
                return 2000;
            }
            return (int)TimeUnit.SECONDS.toMillis(60L);
        }));
    }

    private <T> T lookupValue(BindingContext context, String binding, T fallback) {
        return (T)context.lookup(binding).map(typedValue -> typedValue.getValue()).orElse(fallback);
    }
}

