/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.HasMinMuleVersionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.property.ExcludeFromConnectivitySchemaModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.MinMuleVersionUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

public final class ParameterModelsLoaderDelegate {
    private final Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader;
    private final Consumer<MetadataType> typeRegisterer;

    public ParameterModelsLoaderDelegate(Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader, Consumer<MetadataType> typeRegisterer) {
        this.stereotypeModelLoader = stereotypeModelLoader;
        this.typeRegisterer = typeRegisterer;
    }

    public List<ParameterDeclarer> declare(HasParametersDeclarer component, List<ParameterGroupModelParser> groupParsers, ExtensionLoadingContext context) {
        LinkedList<ParameterDeclarer> declarerList = new LinkedList<ParameterDeclarer>();
        groupParsers.forEach(group -> {
            ParameterGroupDeclarer groupDeclarer;
            if ("General".equals(group.getName())) {
                groupDeclarer = component.onDefaultParameterGroup();
            } else {
                groupDeclarer = component.onParameterGroup(group.getName()).withDslInlineRepresentation(group.showsInDsl());
                group.getDisplayModel().ifPresent(arg_0 -> ((ParameterGroupDeclarer)groupDeclarer).withDisplayModel(arg_0));
                group.getLayoutModel().ifPresent(arg_0 -> ((ParameterGroupDeclarer)groupDeclarer).withLayout(arg_0));
                group.getAdditionalModelProperties().forEach(arg_0 -> ((ParameterGroupDeclarer)groupDeclarer).withModelProperty(arg_0));
                groupDeclarer.getDeclaration().setDescription(group.getDescription());
                group.getLayoutModel().ifPresent(arg_0 -> ((ParameterGroupDeclarer)groupDeclarer).withLayout(arg_0));
            }
            group.getExclusiveOptionals().ifPresent(descriptor -> groupDeclarer.withExclusiveOptionals(descriptor.getExclusiveOptionals(), descriptor.isOneRequired()));
            group.getParameterParsers().forEach(parameterParser -> {
                Object parameter = parameterParser.isRequired() ? groupDeclarer.withRequiredParameter(parameterParser.getName()) : groupDeclarer.withOptionalParameter(parameterParser.getName()).defaultingTo(parameterParser.getDefaultValue());
                parameterParser.getMetadataKeyPart().ifPresent(arg_0 -> ParameterModelsLoaderDelegate.lambda$declare$1((ParameterDeclarer)parameter, arg_0));
                Optional<InputResolverModelParser> inputResolverModelParser = parameterParser.getInputResolverModelParser();
                MetadataType metadataType = parameterParser.getType();
                if (inputResolverModelParser.isPresent()) {
                    parameter.ofDynamicType(metadataType);
                } else {
                    parameter.ofType(metadataType);
                }
                parameter.describedAs(parameterParser.getDescription()).withRole(parameterParser.getRole()).withExpressionSupport(parameterParser.getExpressionSupport());
                this.typeRegisterer.accept(metadataType);
                if (parameterParser.isComponentId()) {
                    parameter.asComponentId();
                }
                if (parameterParser.isConfigOverride()) {
                    parameter.asConfigOverride();
                }
                if (parameterParser.isExcludedFromConnectivitySchema()) {
                    parameter.withModelProperty((ModelProperty)new ExcludeFromConnectivitySchemaModelProperty());
                }
                parameterParser.getLayoutModel().ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withLayout(arg_0));
                parameterParser.getDslConfiguration().ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withDsl(arg_0));
                parameterParser.getDeprecationModel().ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withDeprecation(arg_0));
                parameterParser.getDisplayModel().ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withDisplayModel(arg_0));
                parameterParser.getOAuthParameterModelProperty().ifPresent(arg_0 -> ((ParameterDeclarer)parameter).withModelProperty(arg_0));
                parameterParser.getAdditionalModelProperties().forEach(arg_0 -> ((ParameterDeclarer)parameter).withModelProperty(arg_0));
                if (context.isResolveMinMuleVersion()) {
                    parameterParser.getResolvedMinMuleVersion().ifPresent(arg_0 -> ParameterModelsLoaderDelegate.lambda$declare$2((ParameterDeclarer)parameter, arg_0));
                }
                ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)parameter.getDeclaration(), parameterParser);
                this.stereotypeModelLoader.get().addStereotypes((ParameterModelParser)parameterParser, (ParameterDeclarer)parameter);
                declarerList.add((ParameterDeclarer)parameter);
            });
            if (declarerList.stream().noneMatch(p -> p.getDeclaration().isComponentId())) {
                declarerList.stream().filter(p -> p.getDeclaration().getName().equals("name") && p.getDeclaration().isRequired() && p.getDeclaration().getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED && p.getDeclaration().getType() instanceof StringType && p.getDeclaration().getAllowedStereotypeModels().isEmpty()).forEach(p -> p.asComponentId());
            }
        });
        return declarerList;
    }

    private void declareMetadataKeyPartModelProperty(ParameterDeclarer parameterDeclarer, Pair<Integer, Boolean> metadataKeyPart) {
        if (metadataKeyPart != null) {
            parameterDeclarer.withModelProperty((ModelProperty)new MetadataKeyPartModelProperty(((Integer)metadataKeyPart.getFirst()).intValue(), ((Boolean)metadataKeyPart.getSecond()).booleanValue()));
        }
    }

    private static /* synthetic */ void lambda$declare$2(ParameterDeclarer parameter, ResolvedMinMuleVersion resolvedMMV) {
        MinMuleVersionUtils.declarerWithMmv((HasMinMuleVersionDeclarer)parameter, resolvedMMV);
    }

    private static /* synthetic */ void lambda$declare$1(ParameterDeclarer parameter, Pair metadataKeyPart) {
        parameter.withModelProperty((ModelProperty)new MetadataKeyPartModelProperty(((Integer)metadataKeyPart.getFirst()).intValue(), ((Boolean)metadataKeyPart.getSecond()).booleanValue()));
    }
}

