/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.client.sse;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.http.api.sse.ServerSentEvent;
import org.mule.runtime.http.api.sse.client.SseListener;
import org.mule.service.http.common.client.sse.ServerSentEventDecoder;
import org.mule.service.http.test.netty.utils.sse.ServerSentEventTypeSafeMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="Server Sent Events (SSE)")
@Story(value="SSE Source")
public class ServerSentEventDecoderTestCase
extends AbstractMuleTestCase {
    private SseListener eventListener;
    private ServerSentEventDecoder decoder;

    @Before
    public void setUp() {
        this.eventListener = (SseListener)Mockito.mock(SseListener.class);
        this.decoder = new ServerSentEventDecoder(this.eventListener);
    }

    @Test
    public void happyPathDecode() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDecoderTestCase.feedDecoder(this.decoder, "event: message\ndata: message1; line1\ndata: message1; line2\nid: message1\n\nevent: message\ndata: message2; line1\ndata: message2; line2\nid: message2\nretry: 1000\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener, (VerificationMode)Mockito.times((int)2))).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        MatcherAssert.assertThat((Object)eventsCaptor.getAllValues(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "message1; line1\nmessage1; line2", "message1", null), ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "message2; line1\nmessage2; line2", "message2", 1000L)}));
    }

    @Test
    public void dataWithEmptyLines() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDecoderTestCase.feedDecoder(this.decoder, "event: message\ndata: message1; line1\ndata:\ndata: message1; line3\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent event = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)event, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "message1; line1\n\nmessage1; line3")));
    }

    @Test
    public void retryIsNotANumber() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDecoderTestCase.feedDecoder(this.decoder, "event: message\ndata: data\nretry: thisIsAString\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent eventParsed = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)eventParsed, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "data")));
        MatcherAssert.assertThat((String)"Retry should be ignored because it is not a number", (Object)eventParsed.getRetryDelay().isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void unexpectedEventFieldIsJustIgnored() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDecoderTestCase.feedDecoder(this.decoder, "event: message\ndata: data\nthisIsNotExpected: irrelevantValue\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent eventParsed = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)eventParsed, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "data")));
    }

    @Test
    @Issue(value="W-19667148")
    public void eventWithoutEventLineDefaultsToMessage() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(ServerSentEvent.class);
        ServerSentEventDecoderTestCase.feedDecoder(this.decoder, "data: data\n\n");
        ((SseListener)Mockito.verify((Object)this.eventListener)).onEvent((ServerSentEvent)eventsCaptor.capture());
        ((SseListener)Mockito.verify((Object)this.eventListener)).onClose();
        ServerSentEvent eventParsed = (ServerSentEvent)eventsCaptor.getValue();
        MatcherAssert.assertThat((Object)eventParsed, (Matcher)Matchers.is(ServerSentEventTypeSafeMatcher.aServerSentEvent("message", "data")));
    }

    private static void feedDecoder(ServerSentEventDecoder sseDecoder, String payload) {
        try (ServerSentEventDecoder serverSentEventDecoder = sseDecoder;){
            int chunkLength = 10;
            int length = payload.length();
            for (int begin = 0; begin < length; begin += chunkLength) {
                int end = Math.min(begin + chunkLength, length);
                String chunk = payload.substring(begin, end);
                sseDecoder.decode(chunk.getBytes(), chunk.length());
            }
        }
    }
}

