/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@Ignore(value="W-19471841")
public class SlowResponsesHandlingTestCase
extends AbstractHttpServerTestCase {
    @Rule
    public SystemProperty selectorsTimeout = new SystemProperty("mule.timeoutToUseSelectorWhileStreamingResponseMillis", "0");
    private static final long TIME_PER_BYTE = 100L;
    private static final int REQUESTS = 100;
    private static final int LATCH_TIMEOUT = 5000;
    private static final String ENDPOINT = "/firstSlow";
    private AtomicInteger requestNumber = new AtomicInteger(0);
    private static CountDownLatch start = new CountDownLatch(1);
    private final CountDownLatch latch = new CountDownLatch(100);
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public SlowResponsesHandlingTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @Override
    protected void setUpServer() throws Exception {
        this.server = this.service.getServerFactory().create(this.configureServer(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.getNumber()).setName(this.getServerName()).setSchedulerSupplier(() -> this.getSchedulerService().ioScheduler())).build());
        this.server.start();
    }

    @Before
    public void setUp() throws Exception {
        this.setUpServer();
        this.registerHandler("Success!");
    }

    private void registerHandler(String payload) {
        this.server.addRequestHandler(Collections.singletonList(HttpConstants.Method.GET.name()), ENDPOINT, (requestContext, responseCallback) -> {
            InputStream response;
            if (this.requestNumber.getAndIncrement() == 0) {
                start.countDown();
                response = new InputStream(){
                    private int numreads = 0;

                    @Override
                    public int read() throws IOException {
                        try {
                            Thread.sleep(100L);
                            return (long)this.numreads++ <= 60L ? 1 : -1;
                        }
                        catch (InterruptedException e) {
                            return -1;
                        }
                    }
                };
            } else {
                response = new ByteArrayInputStream(payload.getBytes());
            }
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)org.mule.runtime.http.api.domain.message.response.HttpResponse.builder().entity((HttpEntity)new InputStreamHttpEntity(response))).addHeader("Content-Type", MediaType.TEXT.toRfcString())).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        }).start();
    }

    @Override
    protected String getServerName() {
        return "slow-responses";
    }

    @Test
    public void onlySlowRequestFails() throws Exception {
        AtomicInteger correctCount = new AtomicInteger(0);
        this.performRequestInThread(null);
        start.await();
        for (int i = 0; i < 100; ++i) {
            this.performRequestInThread(correctCount);
        }
        if (!this.latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)String.format("We only got %d responses out of %d", correctCount.get(), 100));
        }
    }

    protected String getUrl(String path) {
        return String.format("http://%s:%s/%s", this.server.getServerAddress().getIp(), this.port.getNumber(), path);
    }

    private void performRequestInThread(AtomicInteger counter) {
        this.executor.submit(() -> {
            try {
                Request request = Request.Get((String)this.getUrl(ENDPOINT));
                HttpResponse response = request.execute().returnResponse();
                StatusLine statusLine = response.getStatusLine();
                MatcherAssert.assertThat((Object)statusLine.getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
                if (counter != null) {
                    counter.incrementAndGet();
                    this.latch.countDown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

