/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.jdbc.SchemaUpdater;
import org.togglz.core.repository.util.DefaultMapSerializer;
import org.togglz.core.repository.util.MapSerializer;
import org.togglz.core.util.DbUtils;
import org.togglz.core.util.Strings;

public class JDBCStateRepository
implements StateRepository {
    protected final DataSource dataSource;
    protected final String tableName;
    protected final MapSerializer serializer;
    protected final boolean noCommit;
    protected final boolean usePostgresTextColumns;

    public JDBCStateRepository(DataSource dataSource) {
        this(new Builder(dataSource));
    }

    public JDBCStateRepository(DataSource dataSource, String tableName) {
        this(new Builder(dataSource).tableName(tableName));
    }

    public JDBCStateRepository(Builder builder) {
        this.dataSource = builder.dataSource;
        this.tableName = builder.tableName;
        this.serializer = builder.serializer;
        this.noCommit = builder.noCommit;
        this.usePostgresTextColumns = builder.usePostgresTextColumns;
        if (builder.createTable) {
            this.migrateSchema();
        }
    }

    protected void migrateSchema() {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                this.beforeSchemaMigration(connection);
                SchemaUpdater updater = new SchemaUpdater(connection, this.tableName, this.serializer);
                if (!updater.doesTableExist()) {
                    updater.migrateToVersion1();
                }
                if (updater.isSchemaVersion1()) {
                    updater.migrateToVersion2();
                }
                if (this.usePostgresTextColumns && updater.isPostgres()) {
                    updater.migrateToTextColumns();
                }
                this.afterSchemaMigration(connection);
            }
            finally {
                DbUtils.closeQuietly(connection);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to migrate the database schema", e);
        }
    }

    protected void beforeSchemaMigration(Connection connection) {
    }

    protected void afterSchemaMigration(Connection connection) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FeatureState getFeatureState(Feature feature) {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                String sql = "SELECT FEATURE_ENABLED, STRATEGY_ID, STRATEGY_PARAMS FROM %TABLE% WHERE FEATURE_NAME = ?";
                PreparedStatement statement = connection.prepareStatement(this.insertTableName(sql));
                try {
                    statement.setString(1, feature.name());
                    ResultSet resultSet = statement.executeQuery();
                    try {
                        String paramData;
                        if (!resultSet.next()) return null;
                        boolean enabled = resultSet.getInt("FEATURE_ENABLED") > 0;
                        FeatureState state = new FeatureState(feature, enabled);
                        String strategyId = resultSet.getString("STRATEGY_ID");
                        if (Strings.isNotBlank(strategyId)) {
                            state.setStrategyId(strategyId.trim());
                        }
                        if (Strings.isNotBlank(paramData = resultSet.getString("STRATEGY_PARAMS"))) {
                            Map<String, String> params = this.serializer.deserialize(paramData);
                            for (Map.Entry<String, String> param : params.entrySet()) {
                                state.setParameter(param.getKey(), param.getValue());
                            }
                        }
                        FeatureState featureState = state;
                        return featureState;
                    }
                    finally {
                        DbUtils.closeQuietly(resultSet);
                    }
                }
                finally {
                    DbUtils.closeQuietly(statement);
                }
            }
            finally {
                DbUtils.closeQuietly(connection);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to fetch the feature's state from the database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFeatureState(FeatureState featureState) {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                int updatedRows = 0;
                String updateSql = "UPDATE %TABLE% SET FEATURE_ENABLED = ?, STRATEGY_ID = ?, STRATEGY_PARAMS = ? WHERE FEATURE_NAME = ?";
                PreparedStatement updateStatement = connection.prepareStatement(this.insertTableName(updateSql));
                try {
                    String paramData = this.serializer.serialize(featureState.getParameterMap());
                    updateStatement.setInt(1, featureState.isEnabled() ? 1 : 0);
                    updateStatement.setString(2, Strings.trimToNull(featureState.getStrategyId()));
                    updateStatement.setString(3, Strings.trimToNull(paramData));
                    updateStatement.setString(4, featureState.getFeature().name());
                    updatedRows = updateStatement.executeUpdate();
                }
                finally {
                    DbUtils.closeQuietly(updateStatement);
                }
                if (updatedRows == 0) {
                    String insertSql = "INSERT INTO %TABLE% (FEATURE_NAME, FEATURE_ENABLED, STRATEGY_ID, STRATEGY_PARAMS) VALUES (?,?,?,?)";
                    PreparedStatement insertStatement = connection.prepareStatement(this.insertTableName(insertSql));
                    try {
                        String paramsAsString = this.serializer.serialize(featureState.getParameterMap());
                        insertStatement.setString(1, featureState.getFeature().name());
                        insertStatement.setInt(2, featureState.isEnabled() ? 1 : 0);
                        insertStatement.setString(3, Strings.trimToNull(featureState.getStrategyId()));
                        insertStatement.setString(4, Strings.trimToNull(paramsAsString));
                        insertStatement.executeUpdate();
                    }
                    finally {
                        DbUtils.closeQuietly(insertStatement);
                    }
                }
                if (!connection.getAutoCommit() && !this.noCommit) {
                    connection.commit();
                }
            }
            finally {
                DbUtils.closeQuietly(connection);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Failed to set the feature's state in the database", e);
        }
    }

    protected String insertTableName(String s) {
        return s.replace("%TABLE%", this.tableName);
    }

    public static Builder newBuilder(DataSource dataSource) {
        return new Builder(dataSource);
    }

    public static class Builder {
        private DataSource dataSource;
        private String tableName = "TOGGLZ";
        private MapSerializer serializer = DefaultMapSerializer.multiline();
        private boolean noCommit = false;
        private boolean createTable = true;
        private boolean usePostgresTextColumns = false;

        public Builder(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder serializer(MapSerializer serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder noCommit(boolean noCommit) {
            this.noCommit = noCommit;
            return this;
        }

        public Builder createTable(boolean createTable) {
            this.createTable = createTable;
            return this;
        }

        public Builder usePostgresTextColumns(boolean usePostgresTextColumns) {
            this.usePostgresTextColumns = usePostgresTextColumns;
            return this;
        }

        public JDBCStateRepository build() {
            return new JDBCStateRepository(this);
        }
    }
}

