/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.suggester.DefaultSuggestion;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class RegexValueRule
extends Rule {
    private Pattern value;
    private String description;
    private List<String> suggestions = new ArrayList<String>();
    private String label;
    private boolean fullMatch = true;

    public RegexValueRule(Pattern value) {
        this.value = value;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        if (this.suggestions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (String suggestion : this.suggestions) {
            String label = this.label;
            if (StringUtils.isBlank((CharSequence)label)) {
                label = suggestion;
            }
            result.add(new DefaultSuggestion(suggestion, this.description, label));
        }
        return result;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof SimpleTypeNode && (this.fullMatch ? this.getMatcher((SimpleTypeNode)node).matches() : this.getMatcher((SimpleTypeNode)node).find());
    }

    private Matcher getMatcher(SimpleTypeNode node) {
        return this.value.matcher(node.getLiteralValue());
    }

    public RegexValueRule label(String value) {
        this.label = value;
        return this;
    }

    public RegexValueRule suggest(String value) {
        this.suggestions.add(value);
        return this;
    }

    public RegexValueRule description(String description) {
        this.description = description;
        return this;
    }

    public RegexValueRule fullMatch(boolean fullMatch) {
        this.fullMatch = fullMatch;
        return this;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidValue(node, String.valueOf(this.value));
        }
        Matcher matcher = this.getMatcher((SimpleTypeNode)node);
        int i = matcher.groupCount();
        ArrayList<String> groups = new ArrayList<String>();
        if (i > 0) {
            if (this.fullMatch) {
                matcher.matches();
            } else {
                matcher.find();
            }
        }
        for (int j = 1; j <= i; ++j) {
            String group = matcher.group(j);
            groups.add(group);
        }
        return this.createNodeUsingFactory(node, groups.toArray(new String[groups.size()]));
    }

    @Override
    public String getDescription() {
        return "/" + this.value.pattern() + "/";
    }
}

