/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction;

import javax.transaction.TransactionManager;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.transaction.DelegateTransaction;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transaction.TypedTransactionFactory;

public final class DelegateTransactionFactory
implements TypedTransactionFactory {
    @Override
    public Transaction beginTransaction(MuleContext muleContext) throws TransactionException {
        try {
            return this.beginTransaction(muleContext.getConfiguration().getId(), ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(NotificationDispatcher.class), muleContext.getTransactionManager());
        }
        catch (RegistrationException e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("Delegate"), (Throwable)((Object)e));
        }
    }

    @Override
    public Transaction beginTransaction(String applicationName, NotificationDispatcher notificationFirer, TransactionManager transactionManager) throws TransactionException {
        DelegateTransaction delegateTransaction = new DelegateTransaction(applicationName, notificationFirer, transactionManager);
        delegateTransaction.begin();
        return delegateTransaction;
    }

    @Override
    public boolean isTransacted() {
        return true;
    }

    @Override
    public TransactionType getType() {
        return TransactionType.LOCAL;
    }
}

