/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.error;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.core.api.error.Errors;

public final class MuleCoreErrorTypeRepository
implements ErrorTypeRepository {
    private static final ErrorType ANY_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("ANY").build();
    private static final ErrorType SOURCE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("SOURCE").parentErrorType(ANY_ERROR_TYPE).build();
    private static final ErrorType SOURCE_RESPONSE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("SOURCE_RESPONSE").parentErrorType(SOURCE_ERROR_TYPE).build();
    private static final ErrorType UNKNOWN_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("UNKNOWN").parentErrorType(ANY_ERROR_TYPE).build();
    public static final ErrorType CRITICAL_ERROR_TYPE = Errors.CRITICAL_ERROR_TYPE;
    public static final ErrorTypeRepository MULE_CORE_ERROR_TYPE_REPOSITORY = new MuleCoreErrorTypeRepository();
    private Map<ComponentIdentifier, ErrorType> errorTypes = new HashMap<ComponentIdentifier, ErrorType>();
    private Map<ComponentIdentifier, ErrorType> internalErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    private MuleCoreErrorTypeRepository() {
        this.errorTypes.put(Errors.ComponentIdentifiers.Handleable.ANY, ANY_ERROR_TYPE);
        this.errorTypes.put(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE, SOURCE_RESPONSE_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Handleable.SOURCE, SOURCE_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Unhandleable.CRITICAL, CRITICAL_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Handleable.UNKNOWN, UNKNOWN_ERROR_TYPE);
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.TRANSFORMATION, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.EXPRESSION, this.getAnyErrorType());
        ErrorType validationErrorType = this.addErrorType(Errors.ComponentIdentifiers.Handleable.VALIDATION, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.DUPLICATE_MESSAGE, validationErrorType);
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED, this.getAnyErrorType());
        ErrorType connectivityErrorType = this.addErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.RETRY_EXHAUSTED, connectivityErrorType);
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.CLIENT_SECURITY, this.getErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).orElseThrow());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY, this.getErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).orElseThrow());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED, this.getErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).orElseThrow());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.STREAM_MAXIMUM_SIZE_EXCEEDED, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.TRANSACTION, this.getAnyErrorType());
        this.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD, this.getCriticalErrorType());
        this.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE, this.getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).orElseThrow());
        this.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.CANCELLED, this.getCriticalErrorType());
        this.addInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.FATAL, this.getCriticalErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.TIMEOUT, this.getAnyErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.COMPOSITE_ROUTING, this.getErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING).orElseThrow());
        ErrorType sourceErrorType = this.getSourceErrorType();
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE, this.getSourceResponseErrorType());
        this.addErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND, this.getSourceResponseErrorType());
        this.addInternalErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE, sourceErrorType);
        this.addInternalErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND, sourceErrorType);
        this.errorTypes = Collections.unmodifiableMap(this.errorTypes);
        this.internalErrorTypes = Collections.unmodifiableMap(this.internalErrorTypes);
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.errorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.internalErrorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    private ErrorType buildErrorType(ComponentIdentifier identifier, ErrorType parent) {
        if (this.errorTypes.containsKey(identifier) || this.internalErrorTypes.containsKey(identifier)) {
            throw new IllegalStateException(String.format("An error type with identifier '%s' already exists", identifier));
        }
        return ErrorTypeBuilder.builder().namespace(identifier.getNamespace()).identifier(identifier.getName()).parentErrorType(parent).build();
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.errorTypes.get(errorTypeComponentIdentifier));
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.lookupErrorType(errorTypeIdentifier);
        if (!errorType.isPresent()) {
            errorType = Optional.ofNullable(this.internalErrorTypes.get(errorTypeIdentifier));
        }
        return errorType;
    }

    public Collection<String> getErrorNamespaces() {
        return Collections.singleton(Errors.CORE_NAMESPACE_NAME);
    }

    public ErrorType getAnyErrorType() {
        return ANY_ERROR_TYPE;
    }

    public ErrorType getSourceErrorType() {
        return SOURCE_ERROR_TYPE;
    }

    public ErrorType getSourceResponseErrorType() {
        return SOURCE_RESPONSE_ERROR_TYPE;
    }

    public ErrorType getCriticalErrorType() {
        return CRITICAL_ERROR_TYPE;
    }

    public Set<ErrorType> getErrorTypes() {
        return new HashSet<ErrorType>(this.errorTypes.values());
    }

    public Set<ErrorType> getInternalErrorTypes() {
        return new HashSet<ErrorType>(this.internalErrorTypes.values());
    }
}

