/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.smb;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mule.service.http.netty.impl.client.auth.ntlm.util.Crypto;
import org.mule.service.http.netty.impl.client.auth.ntlm.util.Encdec;
import org.mule.service.http.netty.impl.client.auth.ntlm.util.Strings;

public class NtlmUtil {
    public static byte[] getNTHash(String password) throws NoSuchAlgorithmException {
        if (password == null) {
            throw new NullPointerException("Password parameter is required");
        }
        MessageDigest md4 = MessageDigest.getInstance("MD4");
        md4.update(Strings.getUNIBytes(password));
        return md4.digest();
    }

    public static byte[] getLMv2Response(String domain, String user, byte[] passwordHash, byte[] challenge, byte[] clientChallenge) throws GeneralSecurityException {
        byte[] response = new byte[24];
        MessageDigest hmac = Crypto.getHMACT64(passwordHash);
        hmac.update(Strings.getUNIBytes(user.toUpperCase()));
        hmac.update(Strings.getUNIBytes(domain.toUpperCase()));
        hmac = Crypto.getHMACT64(hmac.digest());
        hmac.update(challenge);
        hmac.update(clientChallenge);
        hmac.digest(response, 0, 16);
        System.arraycopy(clientChallenge, 0, response, 16, 8);
        return response;
    }

    public static byte[] nTOWFv2(String domain, String username, byte[] passwordHash) throws NoSuchAlgorithmException {
        MessageDigest hmac = Crypto.getHMACT64(passwordHash);
        hmac.update(Strings.getUNIBytes(username.toUpperCase()));
        hmac.update(Strings.getUNIBytes(domain));
        return hmac.digest();
    }

    public static byte[] getNTLMv2Response(byte[] responseKeyNT, byte[] serverChallenge, byte[] clientChallenge, long nanos1601, byte[] avPairs) throws NoSuchAlgorithmException {
        int avPairsLength = avPairs != null ? avPairs.length : 0;
        byte[] temp = new byte[28 + avPairsLength + 4];
        Encdec.enc_uint32le(257, temp, 0);
        Encdec.enc_uint32le(0, temp, 4);
        Encdec.enc_uint64le(nanos1601, temp, 8);
        System.arraycopy(clientChallenge, 0, temp, 16, 8);
        Encdec.enc_uint32le(0, temp, 24);
        if (avPairs != null) {
            System.arraycopy(avPairs, 0, temp, 28, avPairsLength);
        }
        Encdec.enc_uint32le(0, temp, 28 + avPairsLength);
        return NtlmUtil.computeResponse(responseKeyNT, serverChallenge, temp, 0, temp.length);
    }

    static byte[] computeResponse(byte[] responseKey, byte[] serverChallenge, byte[] clientData, int offset, int length) throws NoSuchAlgorithmException {
        MessageDigest hmac = Crypto.getHMACT64(responseKey);
        hmac.update(serverChallenge);
        hmac.update(clientData, offset, length);
        byte[] mac = hmac.digest();
        byte[] ret = new byte[mac.length + clientData.length];
        System.arraycopy(mac, 0, ret, 0, mac.length);
        System.arraycopy(clientData, 0, ret, mac.length, clientData.length);
        return ret;
    }
}

