/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.grizzly.GracefulShutdownListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ShutdownContext;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOTransport;
import org.slf4j.Logger;

class GracefulShutdownRunner
implements Runnable {
    private static final Logger LOGGER = Grizzly.logger(GracefulShutdownRunner.class);
    private final NIOTransport transport;
    private final Set<GracefulShutdownListener> shutdownListeners;
    private final ExecutorService shutdownService;
    private final long gracePeriod;
    private final TimeUnit timeUnit;

    GracefulShutdownRunner(NIOTransport transport, Set<GracefulShutdownListener> shutdownListeners, ExecutorService shutdownService, long gracePeriod, TimeUnit timeUnit) {
        this.transport = transport;
        this.shutdownListeners = shutdownListeners;
        this.shutdownService = shutdownService;
        this.gracePeriod = gracePeriod;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int listenerCount = this.shutdownListeners.size();
        final CountDownLatch shutdownLatch = new CountDownLatch(listenerCount);
        final HashMap<ShutdownContext, GracefulShutdownListener> contexts = new HashMap<ShutdownContext, GracefulShutdownListener>(listenerCount);
        if (this.gracePeriod <= 0L) {
            for (GracefulShutdownListener l : this.shutdownListeners) {
                ShutdownContext ctx = this.createContext(contexts, l, shutdownLatch);
                l.shutdownRequested(ctx);
            }
        } else {
            this.shutdownService.execute(new Runnable(){

                @Override
                public void run() {
                    for (GracefulShutdownListener l : GracefulShutdownRunner.this.shutdownListeners) {
                        ShutdownContext ctx = GracefulShutdownRunner.this.createContext(contexts, l, shutdownLatch);
                        l.shutdownRequested(ctx);
                    }
                }
            });
        }
        try {
            if (this.gracePeriod <= 0L) {
                shutdownLatch.await();
            } else {
                boolean result;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(LogMessages.WARNING_GRIZZLY_GRACEFULSHUTDOWN_MSG(this.transport.getName() + '[' + Integer.toHexString(this.hashCode()) + ']', this.gracePeriod, (Object)this.timeUnit));
                }
                if (!(result = shutdownLatch.await(this.gracePeriod, this.timeUnit))) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(LogMessages.WARNING_GRIZZLY_GRACEFULSHUTDOWN_EXCEEDED(this.transport.getName() + '[' + Integer.toHexString(this.hashCode()) + ']'));
                    }
                    if (!contexts.isEmpty()) {
                        for (GracefulShutdownListener l : contexts.values()) {
                            l.shutdownForced();
                        }
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(LogMessages.WARNING_GRIZZLY_GRACEFULSHUTDOWN_INTERRUPTED());
            }
            if (!contexts.isEmpty()) {
                for (GracefulShutdownListener l : contexts.values()) {
                    l.shutdownForced();
                }
            }
        }
        finally {
            ReentrantReadWriteLock.WriteLock lock = this.transport.getState().getStateLocker().writeLock();
            lock.lock();
            try {
                if (this.transport.shutdownService == this.shutdownService) {
                    this.transport.finalizeShutdown();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private ShutdownContext createContext(final Map<ShutdownContext, GracefulShutdownListener> contexts, GracefulShutdownListener listener, final CountDownLatch shutdownLatch) {
        ShutdownContext ctx = new ShutdownContext(){
            boolean isNotified;

            @Override
            public Transport getTransport() {
                return GracefulShutdownRunner.this.transport;
            }

            @Override
            public synchronized void ready() {
                if (!this.isNotified) {
                    this.isNotified = true;
                    contexts.remove(this);
                    shutdownLatch.countDown();
                }
            }
        };
        contexts.put(ctx, listener);
        return ctx;
    }
}

