/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.listener;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.Response;
import com.ning.http.client.listener.TransferListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferCompletionHandler
extends AsyncCompletionHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(TransferCompletionHandler.class);
    private final ConcurrentLinkedQueue<TransferListener> listeners = new ConcurrentLinkedQueue();
    private final boolean accumulateResponseBytes;
    private FluentCaseInsensitiveStringsMap headers;
    private long expectedTotal;
    private long seen;

    public TransferCompletionHandler() {
        this(false);
    }

    public TransferCompletionHandler(boolean accumulateResponseBytes) {
        this.accumulateResponseBytes = accumulateResponseBytes;
    }

    public TransferCompletionHandler addTransferListener(TransferListener t) {
        this.listeners.offer(t);
        return this;
    }

    public TransferCompletionHandler removeTransferListener(TransferListener t) {
        this.listeners.remove(t);
        return this;
    }

    public void headers(FluentCaseInsensitiveStringsMap headers) {
        this.headers = headers;
        String contentLength = headers.getFirstValue("Content-Length");
        if (contentLength != null) {
            this.expectedTotal = Long.valueOf(contentLength);
        }
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.fireOnHeaderReceived(headers.getHeaders());
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        AsyncHandler.STATE s = AsyncHandler.STATE.CONTINUE;
        if (this.accumulateResponseBytes) {
            s = super.onBodyPartReceived(content);
        }
        this.fireOnBytesReceived(content.getBodyPartBytes());
        return s;
    }

    @Override
    public Response onCompleted(Response response) throws Exception {
        if (this.seen < this.expectedTotal) {
            this.fireOnBytesSent(this.expectedTotal - this.seen, this.expectedTotal, this.expectedTotal);
        }
        this.fireOnEnd();
        return response;
    }

    @Override
    public AsyncHandler.STATE onHeaderWriteCompleted() {
        if (this.headers != null) {
            this.fireOnHeadersSent(this.headers);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onContentWriteProgress(long amount, long current, long total) {
        this.seen += amount;
        this.fireOnBytesSent(amount, current, total);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public void onThrowable(Throwable t) {
        this.fireOnThrowable(t);
    }

    private void fireOnHeadersSent(FluentCaseInsensitiveStringsMap headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestHeadersSent(headers);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnHeaderReceived(FluentCaseInsensitiveStringsMap headers) {
        for (TransferListener l : this.listeners) {
            try {
                l.onResponseHeadersReceived(headers);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnEnd() {
        for (TransferListener l : this.listeners) {
            try {
                l.onRequestResponseCompleted();
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesReceived(byte[] b) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesReceived(b);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnBytesSent(long amount, long current, long total) {
        for (TransferListener l : this.listeners) {
            try {
                l.onBytesSent(amount, current, total);
            }
            catch (Throwable t) {
                l.onThrowable(t);
            }
        }
    }

    private void fireOnThrowable(Throwable t) {
        for (TransferListener l : this.listeners) {
            try {
                l.onThrowable(t);
            }
            catch (Throwable t2) {
                logger.warn("onThrowable", t2);
            }
        }
    }
}

